/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Contributor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Maintainer;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.rpc.RewriteRpc;
import org.openrewrite.rpc.RpcVisitor;

public class RpcRecipe
extends ScanningRecipe<Integer> {
    private final transient RewriteRpc rpc;
    private transient @Nullable List<Recipe> recipeList;
    private final String remoteId;
    private final RecipeDescriptor descriptor;
    private final String editVisitor;
    private final @Nullable TreeVisitor<?, ExecutionContext> editPreconditionVisitor;
    private final @Nullable String scanVisitor;
    private final @Nullable TreeVisitor<?, ExecutionContext> scanPreconditionVisitor;

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.descriptor.getDescription();
    }

    @Override
    public Set<String> getTags() {
        return this.descriptor.getTags();
    }

    @Override
    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return this.descriptor.getEstimatedEffortPerOccurrence();
    }

    @Override
    public List<RecipeExample> getExamples() {
        return this.descriptor.getExamples();
    }

    @Override
    public List<Contributor> getContributors() {
        return Collections.emptyList();
    }

    @Override
    public List<Maintainer> getMaintainers() {
        return this.descriptor.getMaintainers();
    }

    @Override
    public Integer getInitialValue(ExecutionContext ctx) {
        return 0;
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(Integer acc) {
        return this.scanVisitor == null ? TreeVisitor.noop() : Preconditions.check(this.scanPreconditionVisitor, new RpcVisitor(this.rpc, this.scanVisitor));
    }

    @Override
    public Collection<? extends SourceFile> generate(Integer acc, ExecutionContext ctx) {
        return this.rpc.generate(this.remoteId, ctx);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(Integer acc) {
        return Preconditions.check(this.editPreconditionVisitor, new RpcVisitor(this.rpc, this.editVisitor));
    }

    @Override
    public synchronized List<Recipe> getRecipeList() {
        if (this.recipeList == null) {
            this.recipeList = this.descriptor.getRecipeList().stream().map(r -> this.rpc.prepareRecipe(r.getName(), r.getOptions().stream().filter(opt -> opt.getValue() != null).collect(Collectors.toMap(OptionDescriptor::getName, OptionDescriptor::getValue)))).collect(Collectors.toList());
        }
        return this.recipeList;
    }

    @Override
    public void onComplete(ExecutionContext ctx) {
        String id = (String)ctx.getMessage("org.openrewrite.rpc.id");
        if (id != null) {
            this.rpc.getObject(id, null);
        }
    }

    @Generated
    public RpcRecipe(RewriteRpc rpc, String remoteId, RecipeDescriptor descriptor, String editVisitor, @Nullable TreeVisitor<?, ExecutionContext> editPreconditionVisitor, @Nullable String scanVisitor, @Nullable TreeVisitor<?, ExecutionContext> scanPreconditionVisitor) {
        this.rpc = rpc;
        this.remoteId = remoteId;
        this.descriptor = descriptor;
        this.editVisitor = editVisitor;
        this.editPreconditionVisitor = editPreconditionVisitor;
        this.scanVisitor = scanVisitor;
        this.scanPreconditionVisitor = scanPreconditionVisitor;
    }
}

