/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.NlsRewrite;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeBundleResolver;
import org.openrewrite.marketplace.RecipeListing;

@Incubating(since="8.66.0")
public class RecipeMarketplace {
    private final Category root = new Category("Root");
    private final List<RecipeBundleResolver> resolvers = new ArrayList<RecipeBundleResolver>();

    public RecipeMarketplace setResolvers(RecipeBundleResolver ... resolvers) {
        this.resolvers.clear();
        Collections.addAll(this.resolvers, resolvers);
        return this;
    }

    public @Nullable RecipeListing findRecipe(String name) {
        return this.root.findRecipe(name);
    }

    public Set<RecipeListing> getAllRecipes() {
        return this.root.getAllRecipes();
    }

    public List<Category> getCategories() {
        return this.root.getCategories();
    }

    public void install(RecipeListing recipe, List<String> categoryPath) {
        this.root.install(recipe, categoryPath);
    }

    public Set<RecipeListing> install(RecipeBundleReader bundleReader) {
        RecipeMarketplace marketplace = bundleReader.read();
        this.getRoot().merge(marketplace.getRoot());
        this.getRoot().updateBundle(marketplace.getAllRecipes(), bundleReader.getBundle());
        return marketplace.getAllRecipes();
    }

    @Generated
    Category getRoot() {
        return this.root;
    }

    @Generated
    public List<RecipeBundleResolver> getResolvers() {
        return this.resolvers;
    }

    public class Category {
        private final @NlsRewrite.DisplayName String displayName;
        private @NlsRewrite.DisplayName String description = "";
        private final List<Category> categories = new ArrayList<Category>();
        private final List<RecipeListing> recipes = new ArrayList<RecipeListing>();

        public void merge(Category category) {
            for (RecipeListing recipe : category.recipes) {
                this.recipes.remove(recipe);
                this.recipes.add(recipe.withMarketplace(RecipeMarketplace.this));
            }
            for (Category subCategory : category.categories) {
                Category existingSubCategory = null;
                for (Category c : this.categories) {
                    if (!c.getDisplayName().equals(subCategory.getDisplayName())) continue;
                    existingSubCategory = c;
                    break;
                }
                if (existingSubCategory != null) {
                    existingSubCategory.merge(subCategory);
                    continue;
                }
                this.categories.add(subCategory);
            }
        }

        void updateBundle(Collection<RecipeListing> recipes, RecipeBundle bundle) {
            for (RecipeListing recipe : recipes) {
                if (!this.recipes.contains(recipe)) continue;
                this.recipes.remove(recipe);
                this.recipes.add(recipe.withBundle(bundle));
            }
            for (Category category : this.categories) {
                category.updateBundle(recipes, bundle);
            }
        }

        public @Nullable RecipeListing findRecipe(String name) {
            for (RecipeListing recipe : this.recipes) {
                if (!recipe.getName().equals(name)) continue;
                return recipe;
            }
            for (Category category : this.categories) {
                RecipeListing rd = category.findRecipe(name);
                if (rd == null) continue;
                return rd;
            }
            return null;
        }

        public Set<RecipeListing> getAllRecipes() {
            TreeSet<RecipeListing> recipes = new TreeSet<RecipeListing>();
            this.getAllRecipesRecursive(recipes);
            return recipes;
        }

        private void getAllRecipesRecursive(Set<RecipeListing> recipes) {
            recipes.addAll(this.recipes);
            for (Category category : this.categories) {
                category.getAllRecipesRecursive(recipes);
            }
        }

        public void install(RecipeListing recipe, List<String> categoryPath) {
            recipe = recipe.withMarketplace(RecipeMarketplace.this);
            if (categoryPath.isEmpty()) {
                this.recipes.add(recipe);
                return;
            }
            String firstCategory = categoryPath.get(0);
            Category targetCategory = this.findOrCreateCategory(firstCategory);
            targetCategory.install(recipe, categoryPath.subList(1, categoryPath.size()));
        }

        private Category findOrCreateCategory(String categoryName) {
            for (Category category : this.categories) {
                if (!category.getDisplayName().equals(categoryName)) continue;
                return category;
            }
            Category newCategory = new Category(categoryName);
            this.categories.add(newCategory);
            return newCategory;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<Category> getCategories() {
            return this.categories;
        }

        @Generated
        public List<RecipeListing> getRecipes() {
            return this.recipes;
        }

        @Generated
        public Category(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }
    }
}

