/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.marketplace.RecipeBundle;

public interface RecipeListing {
    public String getName();

    @NlsRewrite.DisplayName
    public String getDisplayName();

    @NlsRewrite.Description
    public String getDescription();

    public @Nullable RecipeBundle getBundle();

    public @Nullable Duration getEstimatedEffortPerOccurrence();

    public List<? extends Option> getOptions();

    default public RecipeDescriptor describe() {
        if (this.getBundle() == null) {
            throw new IllegalStateException("Unable to describe a recipe whose bundle is unknown");
        }
        return this.getBundle().describe(this);
    }

    default public Recipe prepare(Map<String, Object> options) {
        if (this.getBundle() == null) {
            throw new IllegalStateException("Unable to prepare a recipe whose bundle is unknown");
        }
        return this.getBundle().prepare(this, options);
    }

    public static interface Option {
        public String getName();

        @NlsRewrite.DisplayName
        public String getDisplayName();

        @NlsRewrite.Description
        public String getDescription();
    }
}

