/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;

public class YamlRecipeBundle
implements RecipeBundle {
    private final URI uri;
    private final Properties properties;
    private final @Nullable String team;

    public YamlRecipeBundle(URI uri, Properties properties, @Nullable String team) {
        this.uri = uri;
        this.properties = properties;
        this.team = team;
    }

    @Override
    public String getPackageEcosystem() {
        return "yaml";
    }

    @Override
    public String getPackageName() {
        return this.uri.toString();
    }

    @Override
    public String getVersion() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (InputStream in = this.uri.toURL().openStream();){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            return new Checksum("SHA-256", digest.digest()).getHexValue();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read recipe file from " + this.uri, e);
        }
    }

    @Override
    public RecipeDescriptor describe(RecipeListing listing) {
        return this.prepare(listing, Collections.emptyMap()).getDescriptor();
    }

    @Override
    public Recipe prepare(RecipeListing listing, Map<String, Object> options) {
        Recipe recipe;
        block8: {
            InputStream inputStream = this.uri.toURL().openStream();
            try {
                YamlResourceLoader loader = new YamlResourceLoader(inputStream, this.uri, this.properties);
                recipe = Objects.requireNonNull(loader.loadRecipe(listing.getName(), new ResourceLoader.RecipeDetail[0]));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to open stream from " + this.uri, e);
                }
            }
            inputStream.close();
        }
        return recipe;
    }

    @Override
    @Generated
    public @Nullable String getTeam() {
        return this.team;
    }
}

