/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.rpc.Reference;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcObjectData;

public class RpcSendQueue {
    private final int batchSize;
    private final List<RpcObjectData> batch;
    private final Consumer<List<RpcObjectData>> drain;
    private final IdentityHashMap<Object, Integer> refs;
    private final @Nullable String sourceFileType;
    private final boolean trace;
    private @Nullable Object before;

    public RpcSendQueue(int batchSize, ThrowingConsumer<List<RpcObjectData>> drain, IdentityHashMap<Object, Integer> refs, @Nullable String sourceFileType, boolean trace) {
        this.batchSize = batchSize;
        this.batch = new ArrayList<RpcObjectData>(batchSize);
        this.drain = drain;
        this.refs = refs;
        this.sourceFileType = sourceFileType;
        this.trace = trace;
    }

    public void put(RpcObjectData rpcObjectData) {
        this.batch.add(rpcObjectData);
        if (this.batch.size() == this.batchSize) {
            this.flush();
        }
    }

    public void flush() {
        if (this.batch.isEmpty()) {
            return;
        }
        this.drain.accept(new ArrayList<RpcObjectData>(this.batch));
        this.batch.clear();
    }

    public <T, U> void getAndSend(T parent, Function<T, @Nullable U> value) {
        this.getAndSend(parent, value, null);
    }

    public <T, U> void getAndSend(T parent, Function<T, @Nullable U> value, @Nullable Consumer<U> onChange) {
        Object after = value.apply(parent);
        T before = this.before == null ? null : (T)value.apply(this.before);
        this.send(after, before, onChange == null || after == null ? null : () -> onChange.accept(after));
    }

    public <T, U> void getAndSendListAsRef(@Nullable T parent, Function<T, @Nullable List<U>> values, Function<? super U, ?> id, @Nullable Consumer<U> onChange) {
        this.getAndSendList(parent, values, id, onChange, true);
    }

    public <T, U> void getAndSendList(@Nullable T parent, Function<T, @Nullable List<U>> values, Function<? super U, ?> id, @Nullable Consumer<U> onChange) {
        this.getAndSendList(parent, values, id, onChange, false);
    }

    private <T, U> void getAndSendList(@Nullable T parent, Function<T, @Nullable List<U>> values, Function<? super U, ?> id, @Nullable Consumer<U> onChange, boolean asRef) {
        List<U> after = parent == null ? null : values.apply(parent);
        List<U> before = this.before == null ? null : values.apply(this.before);
        this.sendList(after, before, id, onChange, asRef);
    }

    public <T> void send(@Nullable T after, @Nullable T before, @Nullable Runnable onChange) {
        Object afterVal = Reference.getValue(after);
        Object beforeVal = Reference.getValue(before);
        if (beforeVal == afterVal) {
            this.put(new RpcObjectData(RpcObjectData.State.NO_CHANGE, null, null, null, this.trace));
        } else if (beforeVal == null) {
            this.add(after, onChange);
        } else if (afterVal == null) {
            this.put(new RpcObjectData(RpcObjectData.State.DELETE, null, null, null, this.trace));
        } else {
            RpcCodec<Object> afterCodec = RpcCodec.forInstance(afterVal, this.sourceFileType);
            this.put(new RpcObjectData(RpcObjectData.State.CHANGE, RpcSendQueue.getValueType(afterVal), onChange == null && afterCodec == null ? afterVal : null, null, this.trace));
            this.doChange(after, before, onChange, afterCodec);
        }
    }

    <T> void sendList(@Nullable List<T> after, @Nullable List<T> before, Function<? super T, ?> id, @Nullable Consumer<T> onChange, boolean asRef) {
        this.send(after, before, () -> {
            assert (after != null) : "A DELETE event should have been sent.";
            Map<Object, Integer> beforeIdx = this.putListPositions(after, before, id);
            for (Object anAfter : after) {
                Object aBefore;
                Runnable onChangeRun;
                Integer beforePos = beforeIdx.get(id.apply((Object)anAfter));
                Runnable runnable = onChangeRun = onChange == null ? null : () -> onChange.accept(anAfter);
                if (beforePos == null) {
                    this.add(asRef ? Reference.asRef(anAfter) : anAfter, onChangeRun);
                    continue;
                }
                Object v1 = aBefore = before == null ? null : before.get(beforePos);
                if (aBefore == anAfter) {
                    this.put(new RpcObjectData(RpcObjectData.State.NO_CHANGE, null, null, null, this.trace));
                    continue;
                }
                this.put(new RpcObjectData(RpcObjectData.State.CHANGE, RpcSendQueue.getValueType(anAfter), null, null, this.trace));
                this.doChange(anAfter, aBefore, onChangeRun, RpcCodec.forInstance(anAfter, this.sourceFileType));
            }
        });
    }

    private <T> Map<Object, Integer> putListPositions(List<T> after, @Nullable List<T> before, Function<? super T, ?> id) {
        IdentityHashMap<Object, Integer> beforeIdx = new IdentityHashMap<Object, Integer>();
        if (before != null) {
            for (int i = 0; i < before.size(); ++i) {
                beforeIdx.put(id.apply(before.get(i)), i);
            }
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (T t : after) {
            Integer beforePos = (Integer)beforeIdx.get(id.apply(t));
            positions.add(beforePos == null ? -1 : beforePos);
        }
        this.put(new RpcObjectData(RpcObjectData.State.CHANGE, null, positions, null, this.trace));
        return beforeIdx;
    }

    private void add(Object after, @Nullable Runnable onChange) {
        Object afterVal = Objects.requireNonNull(Reference.getValue(after));
        Integer ref = null;
        if (after instanceof Reference) {
            if (this.refs.containsKey(afterVal)) {
                this.put(new RpcObjectData(RpcObjectData.State.ADD, null, null, this.refs.get(afterVal), this.trace));
                return;
            }
            ref = this.refs.size() + 1;
            this.refs.put(afterVal, ref);
        }
        RpcCodec<Object> afterCodec = RpcCodec.forInstance(afterVal, this.sourceFileType);
        this.put(new RpcObjectData(RpcObjectData.State.ADD, RpcSendQueue.getValueType(afterVal), onChange == null && afterCodec == null ? afterVal : null, ref, this.trace));
        this.doChange(afterVal, null, onChange, afterCodec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChange(@Nullable Object after, @Nullable Object before, @Nullable Runnable onChange, @Nullable RpcCodec<Object> afterCodec) {
        Object lastBefore = this.before;
        this.before = before;
        try {
            if (onChange != null) {
                if (after != null) {
                    onChange.run();
                }
            } else if (afterCodec != null && after != null) {
                afterCodec.rpcSend(after, this);
            }
        }
        finally {
            this.before = lastBefore;
        }
    }

    private static @Nullable String getValueType(@Nullable Object after) {
        if (after == null) {
            return null;
        }
        Class<?> type = after.getClass();
        if (type.isPrimitive() || type.getPackage().getName().startsWith("java.lang") || type.equals(UUID.class) || Iterable.class.isAssignableFrom(type)) {
            return null;
        }
        if (Enum.class.isAssignableFrom(type) && !"org.openrewrite.java.tree.JavaType$Primitive".equals(type.getName())) {
            return null;
        }
        return type.getName();
    }
}

