/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Contributor;
import org.openrewrite.Recipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.style.NamedStyles;

public interface ResourceLoader {
    default public @Nullable Recipe loadRecipe(String recipeName, RecipeDetail ... details) {
        return this.listRecipes().stream().filter(r -> r.getName().equals(recipeName)).findFirst().orElse(null);
    }

    public Collection<Recipe> listRecipes();

    public Collection<RecipeDescriptor> listRecipeDescriptors();

    public Collection<NamedStyles> listStyles();

    public Collection<CategoryDescriptor> listCategoryDescriptors();

    @Deprecated
    public Map<String, List<Contributor>> listContributors();

    public Map<String, List<RecipeExample>> listRecipeExamples();

    public static enum RecipeDetail {
        CONTRIBUTORS,
        MAINTAINERS,
        EXAMPLES;


        boolean includedIn(RecipeDetail ... include) {
            for (RecipeDetail detail : include) {
                if (detail != this) continue;
                return true;
            }
            return false;
        }
    }
}

