/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Contributor;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.RecipeLoader;
import org.openrewrite.style.NamedStyles;

public class ClasspathScanningLoader
implements ResourceLoader {
    private final LinkedHashMap<String, Recipe> recipes = new LinkedHashMap();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
    private final LinkedHashSet<RecipeDescriptor> recipeDescriptors = new LinkedHashSet();
    private final List<CategoryDescriptor> categoryDescriptors = new ArrayList<CategoryDescriptor>();
    private final Map<String, List<RecipeExample>> recipeExamples = new HashMap<String, List<RecipeExample>>();
    private final ClassLoader classLoader;
    private final RecipeLoader recipeLoader;
    private @Nullable Runnable performScan;

    public ClasspathScanningLoader(Properties properties, String[] acceptPackages) {
        this.classLoader = ClasspathScanningLoader.class.getClassLoader();
        this.recipeLoader = new RecipeLoader(this.classLoader);
        this.performScan = () -> {
            this.scanClasses(new ClassGraph().acceptPackages(acceptPackages), this.getClass().getClassLoader());
            this.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties, Collections.emptyList(), null);
        };
    }

    public ClasspathScanningLoader(Properties properties, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.recipeLoader = new RecipeLoader(classLoader);
        this.performScan = () -> {
            this.scanClasses(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}), classLoader);
            this.scanYaml(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, Collections.emptyList(), classLoader);
        };
    }

    public ClasspathScanningLoader(Path jar, Properties properties, Collection<? extends ResourceLoader> dependencyResourceLoaders, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.recipeLoader = new RecipeLoader(classLoader);
        String jarName = jar.toFile().getName();
        this.performScan = () -> {
            this.scanClasses(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}), classLoader);
            this.scanYaml(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, dependencyResourceLoaders, classLoader);
        };
    }

    public static ClasspathScanningLoader onlyYaml(Properties properties) {
        ClasspathScanningLoader classpathScanningLoader = new ClasspathScanningLoader();
        classpathScanningLoader.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties, Collections.emptyList(), null);
        return classpathScanningLoader;
    }

    private ClasspathScanningLoader() {
        this.classLoader = ClasspathScanningLoader.class.getClassLoader();
        this.recipeLoader = new RecipeLoader(this.classLoader);
    }

    private void scanYaml(ClassGraph classGraph, Properties properties, Collection<? extends ResourceLoader> dependencyResourceLoaders, @Nullable ClassLoader classLoader) {
        try (ScanResult scanResult = classGraph.scan();){
            ArrayList yamlResourceLoaders = new ArrayList();
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties, classLoader, dependencyResourceLoaders)));
            scanResult.getResourcesWithExtension("yaml").forEachInputStreamIgnoringIOException((res, input) -> yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties, classLoader, dependencyResourceLoaders)));
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                for (Recipe recipe : resourceLoader.listRecipes()) {
                    this.recipes.put(recipe.getName(), recipe);
                }
                this.categoryDescriptors.addAll(resourceLoader.listCategoryDescriptors());
                this.styles.addAll(resourceLoader.listStyles());
                this.recipeExamples.putAll(resourceLoader.listRecipeExamples());
            }
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                this.recipeDescriptors.addAll(resourceLoader.listRecipeDescriptors(this.recipes.values(), this.recipeExamples));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanClasses(ClassGraph classGraph, ClassLoader classLoader) {
        try (ScanResult result = classGraph.ignoreClassVisibility().overrideClassLoaders(new ClassLoader[]{classLoader}).scan();){
            this.configureRecipes(result, Recipe.class.getName());
            this.configureRecipes(result, ScanningRecipe.class.getName());
            for (ClassInfo classInfo : result.getSubclasses(NamedStyles.class.getName())) {
                Class styleClass = classInfo.loadClass();
                Constructor<?> constructor = RecipeIntrospectionUtils.getZeroArgsConstructor(styleClass);
                if (constructor == null) continue;
                constructor.setAccessible(true);
                try {
                    this.styles.add((NamedStyles)constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureRecipes(ScanResult result, String className) {
        for (ClassInfo classInfo : result.getSubclasses(className)) {
            Class recipeClass = classInfo.loadClass();
            if (recipeClass.getName().equals(DeclarativeRecipe.class.getName()) || (recipeClass.getModifiers() & 1) == 0 || (recipeClass.getModifiers() & 0x400) != 0) continue;
            Timer.Builder builder = Timer.builder((String)"rewrite.scan.configure.recipe");
            Timer.Sample sample = Timer.start();
            try {
                Recipe recipe = this.recipeLoader.load(recipeClass, Collections.emptyMap());
                this.recipeDescriptors.add(recipe.getDescriptor());
                this.recipes.put(recipe.getName(), recipe);
                MetricsHelper.successTags(builder.tags(new String[]{"recipe", "elided"}));
            }
            catch (Throwable e) {
                MetricsHelper.errorTags(builder.tags(new String[]{"recipe", recipeClass.getName()}), e);
            }
            finally {
                sample.stop(builder.register((MeterRegistry)Metrics.globalRegistry));
            }
        }
    }

    @Override
    public @Nullable Recipe loadRecipe(String recipeName, ResourceLoader.RecipeDetail ... details) {
        if (this.performScan != null) {
            try {
                return this.recipeLoader.load(recipeName, null);
            }
            catch (IllegalArgumentException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        this.ensureScanned();
        return this.recipes.get(recipeName);
    }

    @Override
    public Collection<Recipe> listRecipes() {
        this.ensureScanned();
        return this.recipes.values();
    }

    private void ensureScanned() {
        if (this.performScan != null) {
            this.performScan.run();
            this.performScan = null;
        }
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        this.ensureScanned();
        return this.recipeDescriptors;
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        this.ensureScanned();
        return this.categoryDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        this.ensureScanned();
        return this.styles;
    }

    @Override
    public Map<String, List<RecipeExample>> listRecipeExamples() {
        this.ensureScanned();
        return this.recipeExamples;
    }

    @Override
    public Map<String, List<Contributor>> listContributors() {
        return Collections.emptyMap();
    }
}

