/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.scheduling.RecipeRunCycle;
import org.openrewrite.scheduling.WatchableExecutionContext;
import org.openrewrite.table.RecipeRunStats;
import org.openrewrite.table.SourcesFileErrors;
import org.openrewrite.table.SourcesFileResults;

public class RecipeScheduler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeRun scheduleRun(Recipe recipe, LargeSourceSet sourceSet, ExecutionContext ctx, int maxCycles, int minCycles) {
        try {
            LargeSourceSet after = this.runRecipeCycles(recipe, sourceSet, ctx, maxCycles, minCycles);
            RecipeRun recipeRun = new RecipeRun(after.getChangeset(), ctx.getMessage("org.openrewrite.dataTables", Collections.emptyMap()));
            return recipeRun;
        }
        finally {
            Path workingDirectoryRoot = (Path)ctx.getMessage("org.openrewrite.scheduling.workingDirectory");
            if (workingDirectoryRoot != null) {
                RecipeScheduler.deleteWorkingDirectory(workingDirectoryRoot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LargeSourceSet runRecipeCycles(Recipe recipe, LargeSourceSet sourceSet, ExecutionContext ctx, int maxCycles, int minCycles) {
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        RecipeRunStats recipeRunStats = new RecipeRunStats(Recipe.noop());
        SourcesFileErrors errorsTable = new SourcesFileErrors(Recipe.noop());
        SourcesFileResults sourceFileResults = new SourcesFileResults(Recipe.noop());
        LargeSourceSet after = sourceSet;
        try {
            for (int i = 1; i <= maxCycles; ++i) {
                if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                    break;
                }
                Cursor rootCursor = new Cursor(null, "root");
                try {
                    RecipeRunCycle<LargeSourceSet> cycle = new RecipeRunCycle<LargeSourceSet>(recipe, i, rootCursor, ctxWithWatch, recipeRunStats, sourceFileResults, errorsTable, LargeSourceSet::edit);
                    ctxWithWatch.putCycle(cycle);
                    after.beforeCycle(i == maxCycles);
                    after = cycle.scanSources(after);
                    after = cycle.generateSources(after);
                    after = cycle.editSources(after);
                    boolean anyRecipeCausingAnotherCycle = false;
                    for (Recipe madeChanges : cycle.getMadeChangesInThisCycle()) {
                        if (!madeChanges.causesAnotherCycle()) continue;
                        anyRecipeCausingAnotherCycle = true;
                    }
                    if (i >= minCycles && (cycle.getMadeChangesInThisCycle().isEmpty() || !anyRecipeCausingAnotherCycle)) {
                        after.afterCycle(true);
                        break;
                    }
                    after.afterCycle(i == maxCycles);
                    ctxWithWatch.resetHasNewMessages();
                    continue;
                }
                finally {
                    rootCursor.clearMessages();
                }
            }
        }
        finally {
            recipeRunStats.flush(ctx);
            this.recursiveOnComplete(recipe, ctxWithWatch);
        }
        return after;
    }

    private void recursiveOnComplete(Recipe recipe, ExecutionContext ctx) {
        recipe.onComplete(ctx);
        for (Recipe r : recipe.getRecipeList()) {
            this.recursiveOnComplete(r, ctx);
        }
    }

    private static void deleteWorkingDirectory(Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> files = Files.list(path);){
                    files.forEach(RecipeScheduler::deleteWorkingDirectory);
                }
            }
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

