/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.rpc.Trace;

public final class RpcObjectData {
    private static final ObjectMapper mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModules(new Module[]{new ParameterNamesModule(), new JavaTimeModule()}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    public static final int ADDED_LIST_ITEM = -1;
    private final State state;
    private final @Nullable String valueType;
    private final @Nullable Object value;
    private final @Nullable Integer ref;
    private @Nullable String trace = Trace.traceSender();

    public RpcObjectData withTrace() {
        RpcObjectData d = new RpcObjectData(this.state, this.valueType, this.value, this.ref);
        d.trace = null;
        return d;
    }

    public <V> @Nullable V getValue() {
        if (this.value instanceof Map && this.valueType != null) {
            try {
                Class<?> valueClass = Class.forName(this.valueType);
                ((Map)this.value).put("@c", this.valueType);
                ((Map)this.value).put("@ref", 1);
                return (V)mapper.convertValue(this.value, valueClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return (V)this.value;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public @Nullable String getValueType() {
        return this.valueType;
    }

    @Generated
    public @Nullable Integer getRef() {
        return this.ref;
    }

    @Generated
    public @Nullable String getTrace() {
        return this.trace;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpcObjectData)) {
            return false;
        }
        RpcObjectData other = (RpcObjectData)o;
        Integer this$ref = this.getRef();
        Integer other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !((Object)this$ref).equals(other$ref)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$valueType = this.getValueType();
        String other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$trace = this.getTrace();
        String other$trace = other.getTrace();
        return !(this$trace == null ? other$trace != null : !this$trace.equals(other$trace));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : ((Object)$ref).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : $trace.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RpcObjectData(state=" + (Object)((Object)this.getState()) + ", valueType=" + this.getValueType() + ", value=" + this.getValue() + ", ref=" + this.getRef() + ", trace=" + this.getTrace() + ")";
    }

    @JsonCreator
    @Generated
    private RpcObjectData() {
        this.state = null;
        this.valueType = null;
        this.value = null;
        this.ref = null;
    }

    @Generated
    public RpcObjectData(State state, @Nullable String valueType, @Nullable Object value, @Nullable Integer ref) {
        this.state = state;
        this.valueType = valueType;
        this.value = value;
        this.ref = ref;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public static enum State {
        NO_CHANGE,
        ADD,
        DELETE,
        CHANGE,
        END_OF_OBJECT;

    }
}

