/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.request;

import io.moderne.jsonrpc.JsonRpcMethod;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.objenesis.ObjenesisStd;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.rpc.request.RpcRequest;

public final class Print
implements RpcRequest {
    private final String treeId;
    private final String sourceFileType;
    private final @Nullable MarkerPrinter markerPrinter;

    @Generated
    public Print(String treeId, String sourceFileType, @Nullable MarkerPrinter markerPrinter) {
        this.treeId = treeId;
        this.sourceFileType = sourceFileType;
        this.markerPrinter = markerPrinter;
    }

    @Generated
    public String getTreeId() {
        return this.treeId;
    }

    @Generated
    public String getSourceFileType() {
        return this.sourceFileType;
    }

    @Generated
    public @Nullable MarkerPrinter getMarkerPrinter() {
        return this.markerPrinter;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Print)) {
            return false;
        }
        Print other = (Print)o;
        String this$treeId = this.getTreeId();
        String other$treeId = other.getTreeId();
        if (this$treeId == null ? other$treeId != null : !this$treeId.equals(other$treeId)) {
            return false;
        }
        String this$sourceFileType = this.getSourceFileType();
        String other$sourceFileType = other.getSourceFileType();
        if (this$sourceFileType == null ? other$sourceFileType != null : !this$sourceFileType.equals(other$sourceFileType)) {
            return false;
        }
        MarkerPrinter this$markerPrinter = this.getMarkerPrinter();
        MarkerPrinter other$markerPrinter = other.getMarkerPrinter();
        return !(this$markerPrinter == null ? other$markerPrinter != null : !((Object)((Object)this$markerPrinter)).equals((Object)other$markerPrinter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $treeId = this.getTreeId();
        result = result * 59 + ($treeId == null ? 43 : $treeId.hashCode());
        String $sourceFileType = this.getSourceFileType();
        result = result * 59 + ($sourceFileType == null ? 43 : $sourceFileType.hashCode());
        MarkerPrinter $markerPrinter = this.getMarkerPrinter();
        result = result * 59 + ($markerPrinter == null ? 43 : ((Object)((Object)$markerPrinter)).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Print(treeId=" + this.getTreeId() + ", sourceFileType=" + this.getSourceFileType() + ", markerPrinter=" + (Object)((Object)this.getMarkerPrinter()) + ")";
    }

    public static enum MarkerPrinter {
        DEFAULT,
        SEARCH_MARKERS_ONLY,
        FENCED,
        SANITIZED;


        public static MarkerPrinter from(PrintOutputCapture.MarkerPrinter markerPrinter) {
            if (markerPrinter == PrintOutputCapture.MarkerPrinter.DEFAULT) {
                return DEFAULT;
            }
            if (markerPrinter == PrintOutputCapture.MarkerPrinter.SEARCH_MARKERS_ONLY) {
                return SEARCH_MARKERS_ONLY;
            }
            if (markerPrinter == PrintOutputCapture.MarkerPrinter.FENCED) {
                return FENCED;
            }
            if (markerPrinter == PrintOutputCapture.MarkerPrinter.SANITIZED) {
                return SANITIZED;
            }
            throw new IllegalArgumentException("Unknown marker printer " + markerPrinter);
        }

        private PrintOutputCapture.MarkerPrinter toPrintOutputCapture() {
            switch (this.ordinal()) {
                case 0: {
                    return PrintOutputCapture.MarkerPrinter.DEFAULT;
                }
                case 1: {
                    return PrintOutputCapture.MarkerPrinter.SEARCH_MARKERS_ONLY;
                }
                case 2: {
                    return PrintOutputCapture.MarkerPrinter.FENCED;
                }
                case 3: {
                    return PrintOutputCapture.MarkerPrinter.SANITIZED;
                }
            }
            throw new IllegalArgumentException("Unknown marker printer: " + (Object)((Object)this));
        }
    }

    public static class Handler
    extends JsonRpcMethod<Print> {
        private final Function<String, ?> getObject;

        protected Object handle(Print request) throws Exception {
            Tree tree = (Tree)this.getObject.apply(request.getTreeId());
            try {
                Class<?> sourceFileClass = Class.forName(request.getSourceFileType());
                SourceFile dummySourceFile = (SourceFile)new ObjenesisStd().newInstance(sourceFileClass);
                PrintOutputCapture<Integer> outputCapture = request.getMarkerPrinter() != null ? new PrintOutputCapture<Integer>(0, request.getMarkerPrinter().toPrintOutputCapture()) : new PrintOutputCapture<Integer>(0);
                Cursor dummyCursor = new Cursor(null, dummySourceFile);
                TreeVisitor<?, PrintOutputCapture<PrintOutputCapture<Integer>>> printer = dummySourceFile.printer(dummyCursor);
                printer.visit(tree, outputCapture);
                return outputCapture.getOut();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unknown source file type: " + request.getSourceFileType(), e);
            }
        }

        @Generated
        public Handler(Function<String, ?> getObject) {
            this.getObject = getObject;
        }
    }
}

