/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;

public abstract class ScanningRecipe<T>
extends Recipe {
    private @Nullable String recipeAccMessage;

    private String getRecipeAccMessage() {
        if (this.recipeAccMessage == null) {
            this.recipeAccMessage = "org.openrewrite.recipe.acc." + UUID.randomUUID();
        }
        return this.recipeAccMessage;
    }

    public abstract T getInitialValue(ExecutionContext var1);

    public abstract TreeVisitor<?, ExecutionContext> getScanner(T var1);

    public Collection<? extends SourceFile> generate(T acc, Collection<SourceFile> generatedInThisCycle, ExecutionContext ctx) {
        return this.generate(acc, ctx);
    }

    public Collection<? extends SourceFile> generate(T acc, ExecutionContext ctx) {
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(T acc) {
        return TreeVisitor.noop();
    }

    public T getAccumulator(Cursor cursor, ExecutionContext ctx) {
        return (T)cursor.getRoot().computeMessageIfAbsent(this.getRecipeAccMessage(), m -> this.getInitialValue(ctx));
    }

    @Override
    public final TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            private @Nullable TreeVisitor<?, ExecutionContext> delegate;

            private TreeVisitor<?, ExecutionContext> delegate(ExecutionContext ctx) {
                if (this.delegate == null) {
                    this.delegate = ScanningRecipe.this.getVisitor(ScanningRecipe.this.getAccumulator(this.getCursor(), ctx));
                }
                return this.delegate;
            }

            @Override
            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return this.delegate(ctx).isAcceptable(sourceFile, ctx);
            }

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
                return this.delegate(ctx).visit(tree, ctx, parent);
            }

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                return this.delegate(ctx).visit(tree, ctx);
            }
        };
    }
}

