/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.objenesis.ObjenesisStd;
import org.openrewrite.marker.Markers;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcObjectData;
import org.openrewrite.rpc.Trace;

public class RpcReceiveQueue {
    private static final ObjenesisStd objenesis = new ObjenesisStd();
    private static final LoadingCache<String, Object> instanceCache = Caffeine.newBuilder().maximumSize(1000L).build(key -> {
        try {
            Class<?> clazz = Class.forName(key);
            return objenesis.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    });
    private final Deque<RpcObjectData> batch;
    private final Map<Integer, Object> refs;
    private final @Nullable PrintStream logFile;
    private final Supplier<List<RpcObjectData>> pull;

    public RpcReceiveQueue(Map<Integer, Object> refs, @Nullable PrintStream logFile, Supplier<List<RpcObjectData>> pull) {
        this.refs = refs;
        this.batch = new ArrayDeque<RpcObjectData>();
        this.logFile = logFile;
        this.pull = pull;
    }

    public RpcObjectData take() {
        if (this.batch.isEmpty()) {
            List<RpcObjectData> data = this.pull.get();
            this.batch.addAll(data);
        }
        return this.batch.remove();
    }

    public <T, U> T receiveAndGet(@Nullable T before, Function<U, @Nullable T> mapping) {
        T after = this.receive(before, null);
        return after != null && after != before ? mapping.apply(after) : after;
    }

    public Markers receiveMarkers(Markers markers) {
        return this.receive(markers, m -> m.withId(this.receiveAndGet(m.getId(), UUID::fromString)).withMarkers(this.receiveList(m.getMarkers(), null)));
    }

    public <T> T receive(@Nullable T before) {
        return this.receive(before, null);
    }

    public <T> @Nullable T receive(@Nullable T before, @Nullable UnaryOperator<T> onChange) {
        RpcObjectData message = this.take();
        if (this.logFile != null && message.getTrace() != null) {
            this.logFile.println(message.withTrace(null));
            this.logFile.println("  " + message.getTrace());
            this.logFile.println("  " + Trace.traceReceiver());
            this.logFile.flush();
        }
        Integer ref = null;
        switch (message.getState()) {
            case NO_CHANGE: {
                return before;
            }
            case DELETE: {
                return null;
            }
            case ADD: {
                ref = message.getRef();
                if (ref != null && message.getValueType() == null && message.getValue() == null) {
                    if (this.refs.containsKey(ref)) {
                        return (T)this.refs.get(ref);
                    }
                    throw new IllegalStateException("Received a reference to an object that was not previously sent: " + ref);
                }
                before = message.getValueType() == null ? message.getValue() : this.newObj(message.getValueType());
            }
            case CHANGE: {
                Object after = onChange != null ? onChange.apply(before) : (before instanceof RpcCodec ? ((RpcCodec)before).rpcReceive(before, this) : (message.getValueType() == null ? message.getValue() : before));
                if (ref != null) {
                    this.refs.put(ref, after);
                }
                return (T)after;
            }
        }
        throw new UnsupportedOperationException("Unknown state type " + (Object)((Object)message.getState()));
    }

    public <T> @Nullable List<T> receiveList(@Nullable List<T> before, @Nullable UnaryOperator<T> onChange) {
        RpcObjectData msg = this.take();
        switch (msg.getState()) {
            case NO_CHANGE: {
                return before;
            }
            case DELETE: {
                return null;
            }
            case ADD: {
                before = new ArrayList<T>();
            }
            case CHANGE: {
                msg = this.take();
                assert (msg.getState() == RpcObjectData.State.CHANGE);
                List positions = Objects.requireNonNull((List)msg.getValue());
                ArrayList<Object> after = new ArrayList<Object>(positions.size());
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    int beforeIdx = (Integer)iterator.next();
                    after.add(this.receive(beforeIdx >= 0 ? (T)Objects.requireNonNull(before).get(beforeIdx) : null, onChange));
                }
                return after;
            }
        }
        throw new UnsupportedOperationException((Object)((Object)msg.getState()) + " is not supported for lists.");
    }

    private <T> T newObj(String type) {
        return (T)Objects.requireNonNull(instanceCache.get((Object)type));
    }

    public static <T extends Enum<T>> Function<Object, T> toEnum(Class<T> enumType) {
        return value -> Enum.valueOf(enumType, (String)value);
    }
}

