/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.InMemoryDiffEntry;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.shaded.jgit.lib.FileMode;

public class Result {
    @Nullable
    private final SourceFile before;
    @Nullable
    private final SourceFile after;
    private final Collection<List<Recipe>> recipes;
    @Nullable
    private final Duration timeSavings;

    public Result(@Nullable SourceFile before, @Nullable SourceFile after, Collection<List<Recipe>> recipes) {
        this.before = before;
        this.after = after;
        this.recipes = recipes;
        Duration timeSavings = null;
        for (List<Recipe> recipesStack : recipes) {
            Duration perOccurrence;
            if (recipesStack == null || recipesStack.isEmpty() || (perOccurrence = recipesStack.get(recipesStack.size() - 1).getEstimatedEffortPerOccurrence()) == null) continue;
            timeSavings = perOccurrence;
            break;
        }
        this.timeSavings = timeSavings;
    }

    public Result(@Nullable SourceFile before, SourceFile after) {
        this(before, after, after.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change")).getRecipes());
    }

    public List<RecipeDescriptor> getRecipeDescriptorsThatMadeChanges() {
        ArrayList<RecipeDescriptor> recipesToDisplay = new ArrayList<RecipeDescriptor>();
        for (List<Recipe> currentStack : this.recipes) {
            RecipeDescriptor index;
            Recipe root = currentStack.size() > 1 ? currentStack.get(1) : currentStack.get(0);
            RecipeDescriptor rootDescriptor = root.getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
            if (recipesToDisplay.contains(rootDescriptor)) {
                index = (RecipeDescriptor)recipesToDisplay.get(recipesToDisplay.indexOf(rootDescriptor));
            } else {
                recipesToDisplay.add(rootDescriptor);
                index = rootDescriptor;
            }
            for (int i = 2; i < currentStack.size(); ++i) {
                RecipeDescriptor nextDescriptor = currentStack.get(i).getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
                if (index.getRecipeList().contains(nextDescriptor)) {
                    index = index.getRecipeList().get(index.getRecipeList().indexOf(nextDescriptor));
                    continue;
                }
                index.getRecipeList().add(nextDescriptor);
                index = nextDescriptor;
            }
        }
        return recipesToDisplay;
    }

    public String diff() {
        return this.diff(null);
    }

    public String diff(@Nullable Path relativeTo) {
        return this.diff(relativeTo, null);
    }

    public String diff(@Nullable Path relativeTo, @Nullable PrintOutputCapture.MarkerPrinter markerPrinter) {
        return this.diff(relativeTo, markerPrinter, false);
    }

    @Incubating(since="7.34.0")
    public String diff(@Nullable Path relativeTo, @Nullable PrintOutputCapture.MarkerPrinter markerPrinter, @Nullable Boolean ignoreAllWhitespace) {
        Path beforePath = this.before == null ? null : this.before.getSourcePath();
        Path afterPath = null;
        if (this.before == null && this.after == null) {
            afterPath = (relativeTo == null ? Paths.get(".", new String[0]) : relativeTo).resolve("partial-" + System.nanoTime());
        } else if (this.after != null) {
            afterPath = this.after.getSourcePath();
        }
        PrintOutputCapture<Integer> out = markerPrinter == null ? new PrintOutputCapture<Integer>(0) : new PrintOutputCapture<Integer>(0, markerPrinter);
        FileMode beforeMode = this.before != null && this.before.getFileAttributes() != null && this.before.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE;
        FileMode afterMode = this.after != null && this.after.getFileAttributes() != null && this.after.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE;
        HashSet<Recipe> recipeSet = new HashSet<Recipe>(this.recipes.size());
        for (List<Recipe> rs : this.recipes) {
            if (rs.isEmpty()) continue;
            recipeSet.add(rs.get(0));
        }
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(beforePath, afterPath, relativeTo, this.before == null ? "" : this.before.printAll(out), this.after == null ? "" : this.after.printAll(out.clone()), recipeSet, beforeMode, afterMode);){
            String string = diffEntry.getDiff(ignoreAllWhitespace);
            return string;
        }
    }

    public String toString() {
        return this.diff();
    }

    @Nullable
    public SourceFile getBefore() {
        return this.before;
    }

    @Nullable
    public SourceFile getAfter() {
        return this.after;
    }

    public Collection<List<Recipe>> getRecipes() {
        return this.recipes;
    }

    @Nullable
    public Duration getTimeSavings() {
        return this.timeSavings;
    }
}

