/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.trait.Reference;

@Incubating(since="8.39.0")
public interface SourceFileWithReferences
extends SourceFile {
    public References getReferences();

    default public SoftReference<References> build(@Nullable SoftReference<@Nullable References> references) {
        References cache;
        References references2 = cache = references == null ? null : references.get();
        if (cache == null || cache.getSourceFile() != this) {
            return new SoftReference<References>(References.build(this));
        }
        return references;
    }

    public static class References {
        private final SourceFile sourceFile;
        private final Set<Reference> references;

        public Collection<Reference> findMatches(Reference.Matcher matcher) {
            ArrayList<Reference> list = new ArrayList<Reference>();
            for (Reference ref : this.references) {
                if (!ref.matches(matcher)) continue;
                list.add(ref);
            }
            return list;
        }

        private static References build(SourceFile sourceFile) {
            HashSet<Reference> references = new HashSet<Reference>();
            ServiceLoader<Reference.Provider> loader = ServiceLoader.load(Reference.Provider.class);
            loader.forEach(provider -> {
                if (provider.isAcceptable(sourceFile)) {
                    references.addAll(provider.getReferences(sourceFile));
                }
            });
            return new References(sourceFile, references);
        }

        @Generated
        private References(SourceFile sourceFile, Set<Reference> references) {
            this.sourceFile = sourceFile;
            this.references = references;
        }

        @Generated
        private SourceFile getSourceFile() {
            return this.sourceFile;
        }

        @Generated
        public Set<Reference> getReferences() {
            return this.references;
        }
    }
}

