/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import io.moderne.jsonrpc.JsonRpc;
import io.moderne.jsonrpc.JsonRpcMethod;
import io.moderne.jsonrpc.JsonRpcRequest;
import io.moderne.jsonrpc.JsonRpcSuccess;
import io.moderne.jsonrpc.internal.SnowflakeId;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.rpc.RpcObjectData;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcRecipe;
import org.openrewrite.rpc.request.Generate;
import org.openrewrite.rpc.request.GenerateResponse;
import org.openrewrite.rpc.request.GetObject;
import org.openrewrite.rpc.request.GetObjectResponse;
import org.openrewrite.rpc.request.GetRecipesResponse;
import org.openrewrite.rpc.request.GetRef;
import org.openrewrite.rpc.request.GetRefResponse;
import org.openrewrite.rpc.request.Parse;
import org.openrewrite.rpc.request.ParseResponse;
import org.openrewrite.rpc.request.PrepareRecipe;
import org.openrewrite.rpc.request.PrepareRecipeResponse;
import org.openrewrite.rpc.request.Print;
import org.openrewrite.rpc.request.RpcRequest;
import org.openrewrite.rpc.request.Visit;
import org.openrewrite.rpc.request.VisitResponse;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class RewriteRpc
implements AutoCloseable {
    private final JsonRpc jsonRpc;
    private final AtomicInteger batchSize = new AtomicInteger(200);
    private final Duration timeout;
    private final AtomicBoolean traceSendPackets = new AtomicBoolean(false);
    private @Nullable PrintStream logFile;
    @VisibleForTesting
    final Map<String, Object> remoteObjects = new HashMap<String, Object>();
    @VisibleForTesting
    final Map<String, Object> localObjects = new HashMap<String, Object>();
    final Map<Object, String> localObjectIds = new IdentityHashMap<Object, String>();
    @VisibleForTesting
    final Map<Integer, Object> remoteRefs = new HashMap<Integer, Object>();
    @VisibleForTesting
    final IdentityHashMap<Object, Integer> localRefs = new IdentityHashMap();

    public static Builder<?> from(final JsonRpc jsonRpc, Environment marketplace) {
        return new Builder(marketplace){

            @Override
            public RewriteRpc build() {
                return new RewriteRpc(jsonRpc, this.marketplace, this.timeout);
            }
        };
    }

    protected RewriteRpc(JsonRpc jsonRpc, final Environment marketplace, Duration timeout) {
        this.timeout = timeout;
        this.jsonRpc = jsonRpc;
        HashMap<String, Recipe> preparedRecipes = new HashMap<String, Recipe>();
        IdentityHashMap<Recipe, Cursor> recipeCursors = new IdentityHashMap<Recipe, Cursor>();
        jsonRpc.rpc("GetRef", (JsonRpcMethod)new GetRef.Handler(this.remoteRefs, this.localRefs, this.batchSize, this.traceSendPackets));
        jsonRpc.rpc("Visit", (JsonRpcMethod)new Visit.Handler(this.localObjects, preparedRecipes, recipeCursors, this::getObject, this::getCursor));
        jsonRpc.rpc("Generate", (JsonRpcMethod)new Generate.Handler(this.localObjects, preparedRecipes, recipeCursors, this::getObject));
        jsonRpc.rpc("GetObject", (JsonRpcMethod)new GetObject.Handler(this.batchSize, this.remoteObjects, this.localObjects, this.localRefs, this.traceSendPackets));
        jsonRpc.rpc("GetRecipes", (JsonRpcMethod)new JsonRpcMethod<Void>(){

            protected Object handle(Void noParams) {
                return marketplace.listRecipeDescriptors();
            }
        });
        jsonRpc.rpc("PrepareRecipe", (JsonRpcMethod)new PrepareRecipe.Handler(preparedRecipes));
        jsonRpc.rpc("Print", (JsonRpcMethod)new JsonRpcMethod<Print>(){

            protected Object handle(Print request) {
                Tree tree = (Tree)RewriteRpc.this.getObject(request.getTreeId());
                Cursor cursor = RewriteRpc.this.getCursor(request.getCursor());
                return tree.print(new Cursor(cursor, tree));
            }
        });
        jsonRpc.bind();
    }

    public RewriteRpc batchSize(int batchSize) {
        this.batchSize.set(batchSize);
        return this;
    }

    public RewriteRpc traceGetObjectOutput() {
        this.traceSendPackets.set(true);
        return this;
    }

    public RewriteRpc traceGetObjectInput(PrintStream log) {
        this.logFile = log;
        return this;
    }

    @Override
    public void close() {
        this.jsonRpc.shutdown();
    }

    public <P> @Nullable Tree visit(SourceFile sourceFile, String visitorName, P p) {
        return this.visit(sourceFile, visitorName, p, null);
    }

    public <P> @Nullable Tree visit(Tree tree, String visitorName, P p, @Nullable Cursor cursor) {
        VisitResponse response = this.scan(tree, visitorName, p, cursor);
        return response.isModified() ? (Tree)this.getObject(tree.getId().toString()) : tree;
    }

    public <P> VisitResponse scan(SourceFile sourceFile, String visitorName, P p) {
        return this.scan(sourceFile, visitorName, p, null);
    }

    public <P> VisitResponse scan(Tree sourceFile, String visitorName, P p, @Nullable Cursor cursor) {
        this.localObjects.put(sourceFile.getId().toString(), sourceFile);
        String pId = this.maybeUnwrapExecutionContext(p);
        List<String> cursorIds = this.getCursorIds(cursor);
        return this.send("Visit", new Visit(visitorName, null, sourceFile.getId().toString(), pId, cursorIds), VisitResponse.class);
    }

    public Collection<? extends SourceFile> generate(String remoteRecipeId, ExecutionContext ctx) {
        String ctxId = this.maybeUnwrapExecutionContext(ctx);
        List generated = this.send("Generate", new Generate(remoteRecipeId, ctxId), GenerateResponse.class);
        if (!generated.isEmpty()) {
            return generated.stream().map(this::getObject).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private <P> String maybeUnwrapExecutionContext(P p) {
        Object p2 = p;
        while (p2 instanceof DelegatingExecutionContext) {
            p2 = ((DelegatingExecutionContext)p2).getDelegate();
        }
        String pId = this.localObjectIds.computeIfAbsent(p2, p3 -> SnowflakeId.generateId());
        if (p2 instanceof ExecutionContext) {
            ((ExecutionContext)p2).putMessage("org.openrewrite.rpc.id", pId);
        }
        this.localObjects.put(pId, p2);
        return pId;
    }

    public List<RecipeDescriptor> getRecipes() {
        return this.send("GetRecipes", null, GetRecipesResponse.class);
    }

    public Recipe prepareRecipe(String id) {
        return this.prepareRecipe(id, Collections.emptyMap());
    }

    public Recipe prepareRecipe(String id, Map<String, Object> options) {
        PrepareRecipeResponse r = this.send("PrepareRecipe", new PrepareRecipe(id, options), PrepareRecipeResponse.class);
        for (OptionDescriptor option : r.getDescriptor().getOptions()) {
            if (!option.isRequired() || options.containsKey(option.getName())) continue;
            throw new IllegalArgumentException("Missing required option `" + option.getName() + "` for recipe `" + id + "`.");
        }
        return new RpcRecipe(this, r.getId(), r.getDescriptor(), r.getEditVisitor(), r.getScanVisitor());
    }

    public Stream<SourceFile> parse(Iterable<Parser.Input> inputs, final @Nullable Path relativeTo, final Parser parser, final ExecutionContext ctx) {
        final ArrayList<Parser.Input> inputList = new ArrayList<Parser.Input>();
        final ArrayList<Parse.Input> mappedInputs = new ArrayList<Parse.Input>();
        for (Parser.Input input : inputs) {
            inputList.add(input);
            if (input.isSynthetic() || !Files.isRegularFile(input.getPath(), new LinkOption[0])) {
                mappedInputs.add(new Parse.StringInput(input.getSource(ctx).readFully(), input.getPath()));
                continue;
            }
            mappedInputs.add(new Parse.PathInput(input.getPath()));
        }
        if (inputList.isEmpty()) {
            return Stream.of(new SourceFile[0]);
        }
        final ParsingEventListener parsingListener = ParsingExecutionContextView.view(ctx).getParsingListener();
        parsingListener.intermediateMessage(String.format("Starting parsing of %,d files", inputList.size()));
        final String parseId = SnowflakeId.generateId();
        return StreamSupport.stream(new Spliterator<SourceFile>(){
            private int index = 0;
            private @Nullable List<String> currentBatch;
            private int batchIndex = 0;
            private boolean isFirstCall = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean tryAdvance(Consumer<? super SourceFile> action) {
                if (this.currentBatch == null || this.batchIndex >= this.currentBatch.size()) {
                    if (this.isFirstCall) {
                        this.currentBatch = RewriteRpc.this.send("Parse", new Parse(parseId, mappedInputs, relativeTo != null ? relativeTo.toString() : null), ParseResponse.class);
                        this.isFirstCall = false;
                    } else {
                        this.currentBatch = RewriteRpc.this.send("Parse", new Parse(parseId, Collections.emptyList(), null), ParseResponse.class);
                    }
                    this.batchIndex = 0;
                    if (this.currentBatch.isEmpty()) {
                        return false;
                    }
                }
                if (this.index >= inputList.size()) {
                    return false;
                }
                Parser.Input input = (Parser.Input)inputList.get(this.index);
                String id = this.currentBatch.get(this.batchIndex);
                ++this.index;
                ++this.batchIndex;
                SourceFile sourceFile = null;
                parsingListener.startedParsing(input);
                try {
                    sourceFile = parser.requirePrintEqualsInput((SourceFile)RewriteRpc.this.getObject(id), input, relativeTo, ctx);
                    if (sourceFile != null) {
                        action.accept(sourceFile);
                        parsingListener.parsed(input, sourceFile);
                    }
                }
                catch (Exception e) {
                    try {
                        sourceFile = ParseError.build(parser, input, relativeTo, ctx, e);
                        if (sourceFile != null) {
                            action.accept(sourceFile);
                            parsingListener.parsed(input, sourceFile);
                        }
                    }
                    catch (Throwable throwable) {
                        if (sourceFile != null) {
                            action.accept(sourceFile);
                            parsingListener.parsed(input, sourceFile);
                        }
                        throw throwable;
                    }
                }
                return true;
            }

            @Override
            public @Nullable Spliterator<SourceFile> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return inputList.size() - this.index;
            }

            @Override
            public int characteristics() {
                return 16464;
            }
        }, false);
    }

    public String print(SourceFile tree) {
        return this.print(tree, new Cursor(null, "root"), null);
    }

    public String print(SourceFile tree, @Nullable Print.MarkerPrinter markerPrinter) {
        return this.print(tree, new Cursor(null, "root"), markerPrinter);
    }

    public String print(Tree tree, Cursor parent, @Nullable Print.MarkerPrinter markerPrinter) {
        this.localObjects.put(tree.getId().toString(), tree);
        return this.send("Print", new Print(tree.getId().toString(), this.getCursorIds(parent), markerPrinter), String.class);
    }

    @VisibleForTesting
    @Nullable List<String> getCursorIds(@Nullable Cursor cursor) {
        List cursorIds = null;
        if (cursor != null) {
            cursorIds = cursor.getPathAsStream().map(c -> {
                String id = c instanceof Tree ? ((Tree)c).getId().toString() : this.localObjectIds.computeIfAbsent(c, c2 -> SnowflakeId.generateId());
                this.localObjects.put(id, c);
                return id;
            }).collect(Collectors.toList());
        }
        return cursorIds;
    }

    @VisibleForTesting
    public <T> T getObject(String id) {
        Object localObject = this.localObjects.get(id);
        String lastKnownId = localObject != null ? id : null;
        RpcReceiveQueue q = new RpcReceiveQueue(this.remoteRefs, this.logFile, () -> this.send("GetObject", new GetObject(id, lastKnownId), GetObjectResponse.class), this::getRef);
        Object remoteObject = q.receive(localObject, null);
        if (q.take().getState() != RpcObjectData.State.END_OF_OBJECT) {
            throw new IllegalStateException("Expected END_OF_OBJECT");
        }
        this.remoteObjects.put(id, remoteObject);
        this.localObjects.put(id, remoteObject);
        return (T)remoteObject;
    }

    private Object getRef(Integer refId) {
        RpcReceiveQueue q = new RpcReceiveQueue(this.remoteRefs, this.logFile, () -> this.send("GetRef", new GetRef(refId), GetRefResponse.class), nestedRefId -> {
            throw new IllegalStateException("Nested ref calls not supported in GetRef: " + nestedRefId);
        });
        Object ref = q.receive(null, null);
        if (q.take().getState() != RpcObjectData.State.END_OF_OBJECT) {
            throw new IllegalStateException("Expected END_OF_OBJECT");
        }
        if (ref == null) {
            throw new IllegalStateException("Reference " + refId + " not found on remote");
        }
        this.remoteRefs.put(refId, ref);
        this.localRefs.put(ref, refId);
        return ref;
    }

    protected <P> P send(String method, @Nullable RpcRequest body, Class<P> responseType) {
        try {
            return (P)((JsonRpcSuccess)this.jsonRpc.send(JsonRpcRequest.newRequest((String)method, (Object)body)).get(this.timeout.getSeconds(), TimeUnit.SECONDS)).getResult(responseType);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    Cursor getCursor(@Nullable List<String> cursorIds) {
        Cursor cursor = new Cursor(null, "root");
        if (cursorIds != null) {
            for (int i = cursorIds.size() - 1; i >= 0; --i) {
                String cursorId = cursorIds.get(i);
                Object cursorObject = this.getObject(cursorId);
                this.remoteObjects.put(cursorId, cursorObject);
                cursor = new Cursor(cursor, cursorObject);
            }
        }
        return cursor;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected final Environment marketplace;
        protected Duration timeout = Duration.ofMinutes(1L);

        protected Builder(Environment marketplace) {
            this.marketplace = marketplace;
        }

        public T timeout(Duration timeout) {
            this.timeout = timeout;
            return (T)this;
        }

        public abstract RewriteRpc build();
    }
}

