/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class ManagedThreadLocal<T extends AutoCloseable> {
    private final ThreadLocal<@Nullable T> threadLocal = new ThreadLocal();

    public T require() {
        AutoCloseable value = (AutoCloseable)this.threadLocal.get();
        if (value == null) {
            throw new IllegalStateException("No managed resource found in current thread context");
        }
        return (T)value;
    }

    public Scope<T> requireOrCreate(Supplier<T> factory) {
        AutoCloseable existing = (AutoCloseable)this.threadLocal.get();
        if (existing != null) {
            return new Scope<AutoCloseable>(existing, () -> {});
        }
        AutoCloseable newValue = (AutoCloseable)factory.get();
        this.threadLocal.set(newValue);
        return new Scope<AutoCloseable>(newValue, () -> {
            try {
                this.threadLocal.remove();
            }
            finally {
                newValue.close();
            }
        });
    }

    public Scope<T> using(T value) {
        AutoCloseable previousValue = (AutoCloseable)this.threadLocal.get();
        this.threadLocal.set(value);
        return new Scope<T>(value, () -> {
            if (previousValue != null) {
                this.threadLocal.set(previousValue);
            } else {
                this.threadLocal.remove();
            }
        });
    }

    public ThreadLocal<@Nullable T> asThreadLocal() {
        return this.threadLocal;
    }

    public boolean isPresent() {
        return this.threadLocal.get() != null;
    }

    public static class Scope<T extends AutoCloseable>
    implements AutoCloseable {
        private final T resource;
        private final AutoCloseable cleanup;

        public <R> R map(Function<T, R> mapper) {
            return mapper.apply(this.resource);
        }

        @Override
        public void close() {
            try {
                this.cleanup.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Generated
        public Scope(T resource, AutoCloseable cleanup) {
            this.resource = resource;
            this.cleanup = cleanup;
        }
    }
}

