/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;

@Incubating(since="8.31.0")
public class RecipeList {
    private final String parentRecipeName;
    private int recipeIndex = 1;
    private List<Recipe> recipes;

    public RecipeList recipe(Recipe.Builder recipe) {
        return this.addRecipe(recipe.build(this.parentRecipeName + "$" + this.recipeIndex++));
    }

    public RecipeList recipe(@NlsRewrite.DisplayName @Language(value="markdown") String displayName, @NlsRewrite.Description @Language(value="markdown") String description, TreeVisitor<? extends Tree, ExecutionContext> visitor) {
        return this.recipe(Recipe.builder(displayName, description).visitor(visitor));
    }

    public RecipeList recipe(Recipe recipe) {
        return this.addRecipe(recipe);
    }

    public List<Recipe> getRecipes() {
        return this.recipes == null ? Collections.emptyList() : this.recipes;
    }

    private RecipeList addRecipe(Recipe recipe) {
        if (this.recipes == null) {
            this.recipes = new ArrayList<Recipe>();
        }
        this.recipes.add(recipe);
        return this;
    }

    @Generated
    public RecipeList(String parentRecipeName) {
        this.parentRecipeName = parentRecipeName;
    }
}

