/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openrewrite.DataTable;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeObserver;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.scheduling.RecipeRunCycle;

public interface ExecutionContext
extends RpcCodec<ExecutionContext> {
    public static final String CURRENT_CYCLE = "org.openrewrite.currentCycle";
    public static final String CURRENT_RECIPE = "org.openrewrite.currentRecipe";
    public static final String DATA_TABLES = "org.openrewrite.dataTables";
    public static final String RUN_TIMEOUT = "org.openrewrite.runTimeout";
    public static final String REQUIRE_PRINT_EQUALS_INPUT = "org.openrewrite.requirePrintEqualsInput";

    @Incubating(since="7.20.0")
    default public ExecutionContext addObserver(TreeObserver.Subscription observer) {
        this.putMessageInCollection("org.openrewrite.internal.treeObservers", observer, () -> Collections.newSetFromMap(new IdentityHashMap()));
        return this;
    }

    @Incubating(since="7.20.0")
    default public Set<TreeObserver.Subscription> getObservers() {
        return this.getMessage("org.openrewrite.internal.treeObservers", Collections.emptySet());
    }

    public Map<String, Object> getMessages();

    public void putMessage(String var1, @Nullable Object var2);

    public <T> @Nullable T getMessage(String var1);

    default public <T> T computeMessageIfAbsent(String key, Function<? super String, ? extends T> defaultValue) {
        return this.getMessages().computeIfAbsent(key, defaultValue);
    }

    default public <V, T> T computeMessage(String key, @Nullable V value, Supplier<T> defaultValue, BiFunction<@Nullable V, ? super T, ? extends T> remappingFunction) {
        T oldMessage = this.getMessage(key);
        if (oldMessage == null) {
            oldMessage = defaultValue.get();
        }
        T newMessage = remappingFunction.apply(value, oldMessage);
        this.putMessage(key, newMessage);
        return newMessage;
    }

    default public <V, C extends Collection<V>> C putMessageInCollection(String key, V value, Supplier<C> newCollection) {
        return (C)this.computeMessage(key, value, newCollection, (v, acc) -> {
            Collection c = (Collection)newCollection.get();
            c.addAll(acc);
            c.add(value);
            return c;
        });
    }

    default public <T> Set<T> putMessageInSet(String key, T value) {
        return this.putMessageInCollection(key, value, HashSet::new);
    }

    default public <T> T getMessage(String key, @Nullable T defaultValue) {
        T t = this.getMessage(key);
        return t == null ? defaultValue : t;
    }

    public <T> @Nullable T pollMessage(String var1);

    default public <T> T pollMessage(String key, T defaultValue) {
        T t = this.pollMessage(key);
        return t == null ? defaultValue : t;
    }

    default public void putCurrentRecipe(Recipe recipe) {
        this.putMessage(CURRENT_RECIPE, recipe);
    }

    public Consumer<Throwable> getOnError();

    public BiConsumer<Throwable, ExecutionContext> getOnTimeout();

    default public int getCycle() {
        return this.getCycleDetails().getCycle();
    }

    default public RecipeRunCycle<?> getCycleDetails() {
        return Objects.requireNonNull((RecipeRunCycle)this.getMessage(CURRENT_CYCLE));
    }

    @Override
    default public void rpcSend(ExecutionContext after, RpcSendQueue q) {
        q.getAndSend(after, ctx -> {
            HashMap messages = new HashMap(ctx.getMessages() == null ? Collections.emptyMap() : ctx.getMessages());
            messages.remove(CURRENT_CYCLE);
            messages.remove(CURRENT_RECIPE);
            messages.remove(DATA_TABLES);
            return messages;
        });
        Map dt = (Map)after.getMessage(DATA_TABLES);
        q.getAndSendList(after, ExecutionContext.sendWholeList(dt == null ? null : dt.keySet()), DataTable::getName, null);
        if (dt != null) {
            for (List rowSet : dt.values()) {
                q.getAndSendList(after, ExecutionContext.sendWholeList(rowSet), row -> Integer.toString(System.identityHashCode(row)), null);
            }
        }
    }

    @Override
    default public ExecutionContext rpcReceive(ExecutionContext before, RpcReceiveQueue q) {
        Map<String, Object> messages = q.receive(before.getMessages());
        for (Map.Entry<String, Object> e : messages.entrySet()) {
            before.putMessage(e.getKey(), e.getValue());
        }
        List dataTables = q.receiveList(Collections.emptyList(), null);
        if (dataTables != null) {
            for (DataTable dataTable : dataTables) {
                List rows = q.receiveList(Collections.emptyList(), null);
                before.computeMessage(DATA_TABLES, rows, ConcurrentHashMap::new, (extract, allDataTables) -> {
                    List dataTablesOfType = (List)allDataTables.computeIfAbsent(dataTable, c -> new ArrayList());
                    dataTablesOfType.addAll(rows);
                    return allDataTables;
                });
            }
        }
        return before;
    }

    public static <T> Function<ExecutionContext, @Nullable List<T>> sendWholeList(@Nullable Collection<T> list) {
        AtomicBoolean retrievedAfter = new AtomicBoolean(false);
        return ctx -> {
            if (!retrievedAfter.getAndSet(true)) {
                return list == null ? null : new ArrayList(list);
            }
            return null;
        };
    }
}

