/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class SourcesFileErrors
extends DataTable<Row> {
    public SourcesFileErrors(Recipe recipe) {
        super(recipe, "Source files that errored on a recipe", "The details of all errors produced by a recipe run.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The file that failed to parse.")
        private final String sourcePath;
        @Column(displayName="Recipe that made changes", description="The specific recipe that made a change.")
        private final String recipe;
        @Column(displayName="Stack trace", description="The stack trace of the failure.")
        private final String stackTrace;

        @Generated
        public Row(String sourcePath, String recipe, String stackTrace) {
            this.sourcePath = sourcePath;
            this.recipe = recipe;
            this.stackTrace = stackTrace;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getRecipe() {
            return this.recipe;
        }

        @Generated
        public String getStackTrace() {
            return this.stackTrace;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            if (this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe)) {
                return false;
            }
            String this$stackTrace = this.getStackTrace();
            String other$stackTrace = other.getStackTrace();
            return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            String $stackTrace = this.getStackTrace();
            result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "SourcesFileErrors.Row(sourcePath=" + this.getSourcePath() + ", recipe=" + this.getRecipe() + ", stackTrace=" + this.getStackTrace() + ")";
        }
    }
}

