/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.trait.Reference;

@Incubating(since="8.39.0")
public interface SourceFileWithReferences
extends SourceFile {
    public References getReferences();

    public static class References {
        private final SourceFile sourceFile;
        private final Set<Reference> references;

        public Collection<Reference> findMatches(Reference.Matcher matcher) {
            return this.findMatchesInternal(matcher, null);
        }

        public Collection<Reference> findMatches(Reference.Matcher matcher, Reference.Kind kind) {
            return this.findMatchesInternal(matcher, kind);
        }

        private List<Reference> findMatchesInternal(Reference.Matcher matcher, @Nullable Reference.Kind kind) {
            ArrayList<Reference> list = new ArrayList<Reference>();
            for (Reference ref : this.references) {
                if (kind != null && ref.getKind() != kind || !ref.matches(matcher)) continue;
                list.add(ref);
            }
            return list;
        }

        public static References build(SourceFile sourceFile) {
            HashSet<Reference> references = new HashSet<Reference>();
            ServiceLoader<Reference.Provider> loader = ServiceLoader.load(Reference.Provider.class);
            loader.forEach(provider -> {
                if (provider.isAcceptable(sourceFile)) {
                    references.addAll(provider.getReferences(sourceFile));
                }
            });
            return new References(sourceFile, references);
        }

        @Generated
        private References(SourceFile sourceFile, Set<Reference> references) {
            this.sourceFile = sourceFile;
            this.references = references;
        }

        @Generated
        public SourceFile getSourceFile() {
            return this.sourceFile;
        }

        @Generated
        public Set<Reference> getReferences() {
            return this.references;
        }
    }
}

