/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.marker.Markers;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c", include=JsonTypeInfo.As.PROPERTY)
public interface Tree {
    public static UUID randomId() {
        return UUID.randomUUID();
    }

    public UUID getId();

    public Markers getMarkers();

    public <T extends Tree> T withMarkers(Markers var1);

    public <T extends Tree> T withId(UUID var1);

    default public <R extends Tree, P> @Nullable R accept(TreeVisitor<R, P> v, P p) {
        return v.defaultValue(this, p);
    }

    public <P> boolean isAcceptable(TreeVisitor<?, P> var1, P var2);

    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return cursor.firstEnclosingOrThrow(SourceFile.class).printer(cursor);
    }

    default public String print(Cursor cursor) {
        return this.print(cursor, new PrintOutputCapture<Integer>(0));
    }

    default public <P> String print(Cursor cursor, PrintOutputCapture<P> out) {
        this.printer(cursor).visit(this, out, cursor);
        return out.getOut();
    }

    default public String print(TreeVisitor<?, PrintOutputCapture<Integer>> printer) {
        PrintOutputCapture<Integer> outputCapture = new PrintOutputCapture<Integer>(0);
        printer.visit(this, outputCapture);
        return outputCapture.getOut();
    }

    default public <P> String printTrimmed(P p, Cursor cursor) {
        return StringUtils.trimIndent(this.print(cursor, new PrintOutputCapture<P>(p)));
    }

    default public String printTrimmed(Cursor cursor) {
        return StringUtils.trimIndent(this.print(cursor));
    }

    default public String printTrimmed(TreeVisitor<?, PrintOutputCapture<Integer>> printer) {
        return StringUtils.trimIndent(this.print(printer));
    }

    default public boolean isScope(@Nullable Tree tree) {
        return tree != null && tree.getId() != null && tree.getId().equals(this.getId());
    }

    default public <T2 extends Tree> T2 cast() {
        return (T2)this;
    }
}

