/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.RecipeException;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jgit.ignore.FastIgnoreRule;
import org.openrewrite.jgit.ignore.IgnoreNode;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class ExcludeFileFromGitignore
extends ScanningRecipe<Repository> {
    @Option(displayName="Paths", description="The paths to find and remove from the gitignore files.", example="/folder/file.txt")
    private final List<String> paths;

    @Override
    public String getDisplayName() {
        return "Remove ignoral of files or directories from .gitignore";
    }

    @Override
    public String getDescription() {
        return "This recipe will remove a file or directory from the .gitignore file. If the file or directory is already in the .gitignore file, it will be removed or negated. If the file or directory is not in the .gitignore file, no action will be taken.";
    }

    @Override
    public Repository getInitialValue(ExecutionContext ctx) {
        return new Repository();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Repository acc) {
        return Preconditions.check(new FindSourceFiles("**/.gitignore"), new PlainTextVisitor<ExecutionContext>(){

            @Override
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                try {
                    acc.addGitignoreFile(text);
                }
                catch (IOException e) {
                    throw new RecipeException("Failed to parse the .gitignore file", new Object[]{e});
                }
                return super.visitText(text, ctx);
            }
        });
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(final Repository acc) {
        for (String path : this.paths) {
            acc.exclude(path);
        }
        return Preconditions.check(new FindSourceFiles("**/.gitignore"), new PlainTextVisitor<ExecutionContext>(){

            @Override
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                String gitignoreFileName = text.getSourcePath().toString();
                gitignoreFileName = gitignoreFileName.startsWith("/") ? gitignoreFileName : "/" + gitignoreFileName;
                IgnoreNode ignoreNode = (IgnoreNode)acc.rules.get(gitignoreFileName.substring(0, gitignoreFileName.lastIndexOf("/") + 1));
                if (ignoreNode != null) {
                    String separator = text.getText().contains("\r\n") ? "\r\n" : "\n";
                    List<String> newRules = ignoreNode.getRules().stream().map(FastIgnoreRule::toString).collect(Collectors.toList());
                    String[] currentContent = text.getText().split(separator);
                    return text.withText(org.apache.commons.lang3.StringUtils.join(this.sortRules(currentContent, newRules), (String)separator));
                }
                return super.visitText(text, ctx);
            }

            private List<String> sortRules(String[] originalRules, List<String> newRules) {
                LinkedList<String> results = new LinkedList<String>();
                Arrays.stream(originalRules).filter(line -> {
                    if (line.startsWith("#") || StringUtils.isBlank(line)) {
                        return true;
                    }
                    return newRules.stream().anyMatch(line::equalsIgnoreCase);
                }).forEach(results::add);
                int resultsIndexCurrentlyAt = 0;
                for (String newRule : newRules) {
                    List resultsSubList = results.subList(resultsIndexCurrentlyAt, results.size());
                    if (resultsSubList.stream().noneMatch(rule -> rule.equalsIgnoreCase(newRule))) {
                        if (resultsIndexCurrentlyAt >= results.size()) {
                            results.add(newRule);
                        } else {
                            results.add(resultsIndexCurrentlyAt, newRule);
                        }
                    } else {
                        resultsIndexCurrentlyAt += resultsSubList.indexOf(newRule);
                    }
                    ++resultsIndexCurrentlyAt;
                }
                return results;
            }
        });
    }

    @Generated
    public ExcludeFileFromGitignore(List<String> paths) {
        this.paths = paths;
    }

    @Generated
    public List<String> getPaths() {
        return this.paths;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ExcludeFileFromGitignore(paths=" + this.getPaths() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcludeFileFromGitignore)) {
            return false;
        }
        ExcludeFileFromGitignore other = (ExcludeFileFromGitignore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ExcludeFileFromGitignore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    public static class Repository {
        private final Map<String, IgnoreNode> rules = new HashMap<String, IgnoreNode>();

        public void exclude(String path) {
            String normalizedPath = path.startsWith("/") ? path : "/" + path;
            List impactingFiles = this.rules.keySet().stream().filter(k -> normalizedPath.toLowerCase().startsWith(k.toLowerCase())).sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
            for (String impactingFile : impactingFiles) {
                String nestedPath;
                IgnoreNode ignoreNode = this.rules.get(impactingFile);
                IgnoreNode.MatchResult isIgnored = this.isIgnored(ignoreNode, nestedPath = normalizedPath.substring(impactingFile.length() - 1));
                if (IgnoreNode.MatchResult.CHECK_PARENT == isIgnored) continue;
                if (IgnoreNode.MatchResult.IGNORED != isIgnored) break;
                ArrayList<FastIgnoreRule> remainingRules = new ArrayList<FastIgnoreRule>();
                boolean done = false;
                for (FastIgnoreRule rule : ignoreNode.getRules()) {
                    if (!rule.getResult() || !this.isMatch(rule, nestedPath)) {
                        remainingRules.add(rule);
                        continue;
                    }
                    if (rule.toString().equals(nestedPath)) continue;
                    if (this.isMatch(rule, nestedPath)) {
                        remainingRules.add(rule);
                        if (done) continue;
                        remainingRules.add(new FastIgnoreRule("!" + nestedPath));
                        done = true;
                        continue;
                    }
                    remainingRules.add(rule);
                }
                IgnoreNode replacedNode = new IgnoreNode(remainingRules);
                this.rules.put(impactingFile, replacedNode);
                if (IgnoreNode.MatchResult.CHECK_PARENT == this.isIgnored(replacedNode, nestedPath)) continue;
            }
        }

        public void addGitignoreFile(PlainText text) throws IOException {
            String gitignoreFileName = text.getSourcePath().toString();
            gitignoreFileName = gitignoreFileName.startsWith("/") ? gitignoreFileName : "/" + gitignoreFileName;
            IgnoreNode ignoreNode = new IgnoreNode();
            ignoreNode.parse(gitignoreFileName, (InputStream)new ByteArrayInputStream(text.getText().getBytes()));
            this.rules.put(gitignoreFileName.substring(0, gitignoreFileName.lastIndexOf("/") + 1), ignoreNode);
        }

        private boolean isMatch(FastIgnoreRule rule, String path) {
            String rulePath = rule.toString();
            if (rulePath.startsWith("!")) {
                rulePath = rulePath.substring(1);
            }
            if (rule.dirOnly() && path.contains(rulePath)) {
                return rule.isMatch(path, true, false);
            }
            return rule.isMatch(path, true, true);
        }

        private IgnoreNode.MatchResult isIgnored(IgnoreNode ignoreNode, String path) {
            IgnoreNode.MatchResult isIgnored = IgnoreNode.MatchResult.CHECK_PARENT;
            for (int i = ignoreNode.getRules().size() - 1; i > -1; --i) {
                FastIgnoreRule rule = (FastIgnoreRule)ignoreNode.getRules().get(i);
                if (!this.isMatch(rule, path)) continue;
                if (rule.getResult()) {
                    isIgnored = IgnoreNode.MatchResult.IGNORED;
                    continue;
                }
                return IgnoreNode.MatchResult.NOT_IGNORED;
            }
            return isIgnored;
        }
    }
}

