/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.DeserializationError;
import org.openrewrite.marker.LstProvenance;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.OutdatedSerializer;
import org.openrewrite.table.DeserializationErrorTable;

public final class FindDeserializationErrors
extends Recipe {
    private final transient DeserializationErrorTable dataTable = new DeserializationErrorTable(this);

    @Override
    public String getDisplayName() {
        return "Find deserialization errors";
    }

    @Override
    public String getDescription() {
        return "Produces a data table collecting all deserialization errors of serialized LSTs.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                return tree.getMarkers().findFirst(DeserializationError.class).map(error -> {
                    Optional<OutdatedSerializer> outdatedSerializer = tree.getMarkers().findFirst(OutdatedSerializer.class);
                    Optional<LstProvenance> lstProvenance = tree.getMarkers().findFirst(LstProvenance.class);
                    FindDeserializationErrors.this.dataTable.insertRow(ctx, new DeserializationErrorTable.Row(tree instanceof SourceFile ? ((SourceFile)tree).getSourcePath().toString() : null, error.getMessage(), error.getDetail(), outdatedSerializer.map(OutdatedSerializer::getLanguage).orElse(null), outdatedSerializer.map(OutdatedSerializer::getMinimumVersion).orElse(null), outdatedSerializer.map(OutdatedSerializer::getActualVersion).orElseGet(() -> lstProvenance.map(LstProvenance::getBuildToolVersion).orElse(null)), lstProvenance.map(LstProvenance::getTimestampUtc).map(Instant::toEpochMilli).orElse(null), lstProvenance.map(LstProvenance::getTimestampUtc).map(ts -> ts.atZone(ZoneOffset.UTC)).map(ZonedDateTime::toString).orElse(null)));
                    return Markup.info(tree, error.getMessage());
                }).orElse(tree);
            }
        };
    }

    @Generated
    public FindDeserializationErrors() {
    }

    @Generated
    public DeserializationErrorTable getDataTable() {
        return this.dataTable;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDeserializationErrors(dataTable=" + this.getDataTable() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeserializationErrors)) {
            return false;
        }
        FindDeserializationErrors other = (FindDeserializationErrors)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDeserializationErrors;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

