/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class ParseToPrintInequalities
extends DataTable<Row> {
    public ParseToPrintInequalities(Recipe recipe) {
        super(recipe, "Parser to print inequalities", "A list of files that parsers produced `SourceFile` which, when printed, didn't match the original source code.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The file that failed to parse.")
        private final String sourcePath;
        @Column(displayName="Diff", description="The diff between the original source code and the printed `SourceFile`.")
        @Nullable
        private final String diff;

        @Generated
        public Row(String sourcePath, @Nullable String diff) {
            this.sourcePath = sourcePath;
            this.diff = diff;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Nullable
        @Generated
        public String getDiff() {
            return this.diff;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$diff = this.getDiff();
            String other$diff = other.getDiff();
            return !(this$diff == null ? other$diff != null : !this$diff.equals(other$diff));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $diff = this.getDiff();
            result = result * 59 + ($diff == null ? 43 : $diff.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ParseToPrintInequalities.Row(sourcePath=" + this.getSourcePath() + ", diff=" + this.getDiff() + ")";
        }
    }
}

