/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.scheduling;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;

class RecipeStack {
    private final Map<Recipe, List<Recipe>> recipeLists = new IdentityHashMap<Recipe, List<Recipe>>();
    private Stack<Stack<Recipe>> allRecipesStack;
    int recipePosition;

    RecipeStack() {
    }

    public <T> T reduce(LargeSourceSet sourceSet, Recipe recipe, ExecutionContext ctx, BiFunction<T, Stack<Recipe>, T> consumer, T acc) {
        this.init(recipe);
        AtomicInteger recipePosition = new AtomicInteger(0);
        while (!this.allRecipesStack.isEmpty() && ctx.getMessage("__AHHH_PANIC!!!__") == null) {
            this.recipePosition = recipePosition.getAndIncrement();
            Stack<Recipe> recipeStack = this.allRecipesStack.pop();
            if (recipeStack.peek().maxCycles() >= ctx.getCycle()) {
                sourceSet.setRecipe(recipeStack);
                acc = consumer.apply(acc, recipeStack);
                this.recurseRecipeList(recipeStack);
                continue;
            }
            this.recipePosition = recipePosition.getAndAdd(this.countRecipes(recipeStack.peek()));
        }
        return acc;
    }

    private void init(Recipe recipe) {
        this.allRecipesStack = new Stack();
        Stack<Recipe> rootRecipeStack = new Stack<Recipe>();
        rootRecipeStack.push(recipe);
        this.allRecipesStack.push(rootRecipeStack);
    }

    private void recurseRecipeList(Stack<Recipe> recipeStack) {
        List<Recipe> recipeList = this.getRecipeList(recipeStack.peek());
        for (int i = recipeList.size() - 1; i >= 0; --i) {
            Recipe r = recipeList.get(i);
            Stack<Recipe> nextStack = new Stack<Recipe>();
            nextStack.addAll(recipeStack);
            nextStack.push(r);
            this.allRecipesStack.push(nextStack);
        }
    }

    private int countRecipes(Recipe recipe) {
        int count = 0;
        List<Recipe> recipeList = this.getRecipeList(recipe);
        for (Recipe subRecipe : recipeList) {
            ++count;
            count += this.countRecipes(subRecipe);
        }
        return count;
    }

    private List<Recipe> getRecipeList(Recipe recipe) {
        return this.recipeLists.computeIfAbsent(recipe, Recipe::getRecipeList);
    }

    @Generated
    public int getRecipePosition() {
        return this.recipePosition;
    }
}

