/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class CreateTextFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="File contents", description="Multiline text content for the file.", example="Some text.")
    private final String fileContents;
    @Option(displayName="Relative file path", description="File path of new file.", example="foo/bar/baz.txt")
    private final String relativeFileName;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    @Nullable
    private final Boolean overwriteExisting;

    @Override
    public String getDisplayName() {
        return "Create text file";
    }

    @Override
    public String getDescription() {
        return "Creates a new plain text file.";
    }

    @Override
    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(Paths.get(this.relativeFileName, new String[0]), shouldCreate);
    }

    @Override
    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return PlainTextParser.builder().build().parse(this.fileContents).map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new TreeVisitor<SourceFile, ExecutionContext>(){

            @Override
            public SourceFile visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if ((created.get() || Boolean.TRUE.equals(CreateTextFile.this.overwriteExisting)) && path.equals(sourceFile.getSourcePath())) {
                    if (sourceFile instanceof PlainText) {
                        return ((PlainText)sourceFile).withText(CreateTextFile.this.fileContents);
                    }
                    PlainText plainText = PlainText.builder().id(sourceFile.getId()).sourcePath(sourceFile.getSourcePath()).fileAttributes(sourceFile.getFileAttributes()).charsetBomMarked(sourceFile.isCharsetBomMarked()).text(CreateTextFile.this.fileContents).build();
                    if (sourceFile.getCharset() != null) {
                        return plainText.withCharset(sourceFile.getCharset());
                    }
                    return plainText;
                }
                return sourceFile;
            }
        };
    }

    @Generated
    public CreateTextFile(String fileContents, String relativeFileName, @Nullable Boolean overwriteExisting) {
        this.fileContents = fileContents;
        this.relativeFileName = relativeFileName;
        this.overwriteExisting = overwriteExisting;
    }

    @Generated
    public String getFileContents() {
        return this.fileContents;
    }

    @Generated
    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Nullable
    @Generated
    public Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CreateTextFile(fileContents=" + this.getFileContents() + ", relativeFileName=" + this.getRelativeFileName() + ", overwriteExisting=" + this.getOverwriteExisting() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTextFile)) {
            return false;
        }
        CreateTextFile other = (CreateTextFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        if (this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        return !(this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CreateTextFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        return result;
    }
}

