/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class Find
extends Recipe {
    @Option(displayName="Find", description="The text to find. This snippet can be multiline.", example="blacklist")
    private final String find;
    @Option(displayName="Regex", description="If true, `find` will be interpreted as a Regular Expression. Default `false`.", required=false)
    @Nullable
    private final Boolean regex;
    @Option(displayName="Case sensitive", description="If `true` the search will be sensitive to case. Default `false`.", required=false)
    @Nullable
    private final Boolean caseSensitive;
    @Option(displayName="Regex multiline mode", description="When performing a regex search setting this to `true` allows \"^\" and \"$\" to match the beginning and end of lines, respectively. When performing a regex search when this is `false` \"^\" and \"$\" will match only the beginning and ending of the entire source file, respectively.Has no effect when not performing a regex search. Default `false`.", required=false)
    @Nullable
    private final Boolean multiline;
    @Option(displayName="Regex dot all", description="When performing a regex search setting this to `true` allows \".\" to match line terminators.Has no effect when not performing a regex search. Default `false`.", required=false)
    @Nullable
    private final Boolean dotAll;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match. When not set, all source files are searched. ", required=false, example="**/*.java")
    @Nullable
    private final String filePattern;

    @Override
    public String getDisplayName() {
        return "Find text";
    }

    @Override
    public String getDescription() {
        return "Search for text, treating all textual sources as plain text.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                String searchStr = Find.this.find;
                if (!Boolean.TRUE.equals(Find.this.regex)) {
                    searchStr = Pattern.quote(searchStr);
                }
                int patternOptions = 0;
                if (!Boolean.TRUE.equals(Find.this.caseSensitive)) {
                    patternOptions |= 2;
                }
                if (Boolean.TRUE.equals(Find.this.multiline)) {
                    patternOptions |= 8;
                }
                if (Boolean.TRUE.equals(Find.this.dotAll)) {
                    patternOptions |= 0x20;
                }
                Pattern pattern = Pattern.compile(searchStr, patternOptions);
                Matcher matcher = pattern.matcher(plainText.getText());
                String rawText = plainText.getText();
                if (!matcher.find()) {
                    return sourceFile;
                }
                matcher.reset();
                ArrayList<PlainText.Snippet> snippets = new ArrayList<PlainText.Snippet>();
                int previousEnd = 0;
                while (matcher.find()) {
                    int matchStart = matcher.start();
                    snippets.add(Find.snippet(rawText.substring(previousEnd, matchStart)));
                    snippets.add(SearchResult.found(Find.snippet(rawText.substring(matchStart, matcher.end()))));
                    previousEnd = matcher.end();
                }
                snippets.add(Find.snippet(rawText.substring(previousEnd)));
                return plainText.withText("").withSnippets(snippets);
            }
        };
        if (this.filePattern != null) {
            TreeVisitor<?, ExecutionContext> check = Preconditions.or((TreeVisitor[])Arrays.stream(this.filePattern.split(";")).map(FindSourceFiles::new).map(Recipe::getVisitor).toArray(TreeVisitor[]::new));
            visitor = Preconditions.check(check, visitor);
        }
        return visitor;
    }

    private static PlainText.Snippet snippet(String text) {
        return new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, text);
    }

    public Find(String find, @Nullable Boolean regex, @Nullable Boolean caseSensitive, @Nullable Boolean multiline, @Nullable Boolean dotAll, @Nullable String filePattern) {
        this.find = find;
        this.regex = regex;
        this.caseSensitive = caseSensitive;
        this.multiline = multiline;
        this.dotAll = dotAll;
        this.filePattern = filePattern;
    }

    public String getFind() {
        return this.find;
    }

    @Nullable
    public Boolean getRegex() {
        return this.regex;
    }

    @Nullable
    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Nullable
    public Boolean getMultiline() {
        return this.multiline;
    }

    @Nullable
    public Boolean getDotAll() {
        return this.dotAll;
    }

    @Nullable
    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    public String toString() {
        return "Find(find=" + this.getFind() + ", regex=" + this.getRegex() + ", caseSensitive=" + this.getCaseSensitive() + ", multiline=" + this.getMultiline() + ", dotAll=" + this.getDotAll() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Find)) {
            return false;
        }
        Find other = (Find)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Boolean this$caseSensitive = this.getCaseSensitive();
        Boolean other$caseSensitive = other.getCaseSensitive();
        if (this$caseSensitive == null ? other$caseSensitive != null : !((Object)this$caseSensitive).equals(other$caseSensitive)) {
            return false;
        }
        Boolean this$multiline = this.getMultiline();
        Boolean other$multiline = other.getMultiline();
        if (this$multiline == null ? other$multiline != null : !((Object)this$multiline).equals(other$multiline)) {
            return false;
        }
        Boolean this$dotAll = this.getDotAll();
        Boolean other$dotAll = other.getDotAll();
        if (this$dotAll == null ? other$dotAll != null : !((Object)this$dotAll).equals(other$dotAll)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        if (this$find == null ? other$find != null : !this$find.equals(other$find)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Find;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Boolean $caseSensitive = this.getCaseSensitive();
        result = result * 59 + ($caseSensitive == null ? 43 : ((Object)$caseSensitive).hashCode());
        Boolean $multiline = this.getMultiline();
        result = result * 59 + ($multiline == null ? 43 : ((Object)$multiline).hashCode());
        Boolean $dotAll = this.getDotAll();
        result = result * 59 + ($dotAll == null ? 43 : ((Object)$dotAll).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

