/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.UUID;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public class DeserializationError
implements Marker {
    private final UUID id;
    private final String message;
    private final String detail;

    public DeserializationError(UUID id, String message, Throwable cause) {
        this.id = id;
        this.message = message;
        this.detail = ExceptionUtils.sanitizeStackTrace(cause, Object.class);
    }

    @JsonCreator
    DeserializationError(UUID id, String message, String detail) {
        this.id = id;
        this.message = message;
        this.detail = detail;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeserializationError)) {
            return false;
        }
        DeserializationError other = (DeserializationError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeserializationError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public DeserializationError withId(UUID id) {
        return this.id == id ? this : new DeserializationError(id, this.message, this.detail);
    }

    @NonNull
    public DeserializationError withMessage(String message) {
        return this.message == message ? this : new DeserializationError(this.id, message, this.detail);
    }

    @NonNull
    public DeserializationError withDetail(String detail) {
        return this.detail == detail ? this : new DeserializationError(this.id, this.message, detail);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetail() {
        return this.detail;
    }

    @NonNull
    public String toString() {
        return "DeserializationError(id=" + this.getId() + ", message=" + this.getMessage() + ", detail=" + this.getDetail() + ")";
    }
}

