/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

@Incubating(since="8.2.0")
public final class FindMultiselect
extends Recipe {
    @Option(displayName="Find", description="The text to find.", example="blacklist")
    private final String find;
    @Option(displayName="Regex", description="If true, `find` will be interpreted as a Regular Expression. Default `false`.", required=false)
    @Nullable
    private final Boolean regex;
    @Option(displayName="Regex options", description="Regex processing options. Multiple options may be specified. These options do nothing if `regex` mode is not enabled.\n* Case-sensitive - The search will be sensitive to letter case. * Multiline - Allows `^` and `$` to match the beginning and end of lines, respectively.* Dot all - Allows `.` to match line terminators.", valid={"Case-sensitive", "Multiline", "Dot all"}, required=false)
    @Nullable
    private final Set<String> regexOptions;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match. When not set, all source files are searched. ", example="**/*.java")
    @Nullable
    private final String filePattern;

    @Override
    public String getDisplayName() {
        return "Experimental find text with multiselect";
    }

    @Override
    public String getDescription() {
        return "Search for text, treating all textual sources as plain text. This version of the recipe exists to experiment with multiselect recipe options.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        Boolean dotAll;
        Boolean multiline;
        Boolean caseSensitive;
        if (this.regexOptions != null) {
            Set lowerCaseOptions = this.regexOptions.stream().map(String::toLowerCase).collect(Collectors.toSet());
            caseSensitive = lowerCaseOptions.contains("Case-sensitive");
            multiline = lowerCaseOptions.contains("Multiline");
            dotAll = lowerCaseOptions.contains("Dot all");
        } else {
            caseSensitive = null;
            multiline = null;
            dotAll = null;
        }
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                String searchStr = FindMultiselect.this.find;
                if (!Boolean.TRUE.equals(FindMultiselect.this.regex)) {
                    searchStr = Pattern.quote(searchStr);
                }
                int patternOptions = 0;
                if (!Boolean.TRUE.equals(caseSensitive)) {
                    patternOptions |= 2;
                }
                if (Boolean.TRUE.equals(multiline)) {
                    patternOptions |= 8;
                }
                if (Boolean.TRUE.equals(dotAll)) {
                    patternOptions |= 0x20;
                }
                Pattern pattern = Pattern.compile(searchStr, patternOptions);
                Matcher matcher = pattern.matcher(plainText.getText());
                String rawText = plainText.getText();
                if (!matcher.find()) {
                    return sourceFile;
                }
                matcher.reset();
                ArrayList<PlainText.Snippet> snippets = new ArrayList<PlainText.Snippet>();
                int previousEnd = 0;
                while (matcher.find()) {
                    int matchStart = matcher.start();
                    snippets.add(FindMultiselect.snippet(rawText.substring(previousEnd, matchStart)));
                    snippets.add(SearchResult.found(FindMultiselect.snippet(rawText.substring(matchStart, matcher.end()))));
                    previousEnd = matcher.end();
                }
                snippets.add(FindMultiselect.snippet(rawText.substring(previousEnd)));
                return plainText.withText("").withSnippets(snippets);
            }
        };
        if (this.filePattern != null) {
            TreeVisitor<?, ExecutionContext> check = Preconditions.or((TreeVisitor[])Arrays.stream(this.filePattern.split(";")).map(FindSourceFiles::new).map(Recipe::getVisitor).toArray(TreeVisitor[]::new));
            visitor = Preconditions.check(check, visitor);
        }
        return visitor;
    }

    private static PlainText.Snippet snippet(String text) {
        return new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, text);
    }

    public FindMultiselect(String find, @Nullable Boolean regex, @Nullable Set<String> regexOptions, @Nullable String filePattern) {
        this.find = find;
        this.regex = regex;
        this.regexOptions = regexOptions;
        this.filePattern = filePattern;
    }

    public String getFind() {
        return this.find;
    }

    @Nullable
    public Boolean getRegex() {
        return this.regex;
    }

    @Nullable
    public Set<String> getRegexOptions() {
        return this.regexOptions;
    }

    @Nullable
    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    public String toString() {
        return "FindMultiselect(find=" + this.getFind() + ", regex=" + this.getRegex() + ", regexOptions=" + this.getRegexOptions() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMultiselect)) {
            return false;
        }
        FindMultiselect other = (FindMultiselect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        if (this$find == null ? other$find != null : !this$find.equals(other$find)) {
            return false;
        }
        Set<String> this$regexOptions = this.getRegexOptions();
        Set<String> other$regexOptions = other.getRegexOptions();
        if (this$regexOptions == null ? other$regexOptions != null : !((Object)this$regexOptions).equals(other$regexOptions)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindMultiselect;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        Set<String> $regexOptions = this.getRegexOptions();
        result = result * 59 + ($regexOptions == null ? 43 : ((Object)$regexOptions).hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

