/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

public class HasSourcePath
extends Recipe {
    @Option(displayName="Syntax", description="Either `glob` or `regex`. Defaults to `glob`.", example="glob", required=false)
    private final String syntax;
    @Option(displayName="File pattern", description="A glob or regex pattern to match against the source path of a source file.", example="foo/**/bar/*.txt", required=false)
    @Nullable
    private final String filePattern;

    public HasSourcePath(@Nullable String filePattern) {
        this("glob", filePattern);
    }

    public HasSourcePath(@Nullable String syntax, @Nullable String filePattern) {
        this.syntax = syntax == null ? "glob" : syntax;
        this.filePattern = filePattern;
    }

    @Override
    public String getDisplayName() {
        return "Has source path";
    }

    @Override
    public String getDescription() {
        return "Matches a source file based on its path, for use as precondition. The path can be matched using either glob or regex syntax. If no syntax is specified, glob syntax is used by default. If no file pattern is specified, all source files are matched. The path is relative to the root of the project.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree preVisit(Tree tree, ExecutionContext p) {
                this.stopAfterPreVisit();
                if (StringUtils.isBlank(HasSourcePath.this.filePattern)) {
                    return SearchResult.found(tree, "has file");
                }
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    Path sourcePath = "glob".equals(HasSourcePath.this.syntax) && HasSourcePath.this.filePattern.startsWith("**") ? Paths.get(".", new String[0]).resolve(sourceFile.getSourcePath().normalize()) : sourceFile.getSourcePath().normalize();
                    PathMatcher pathMatcher = sourcePath.getFileSystem().getPathMatcher(HasSourcePath.this.syntax + ":" + HasSourcePath.this.filePattern);
                    if (pathMatcher.matches(sourcePath)) {
                        return SearchResult.found(sourceFile, "has file");
                    }
                }
                return tree;
            }
        };
    }
}

