/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.LstProvenance;

@JsonIgnoreType
public class LstProvenanceTable
extends DataTable<Row> {
    public LstProvenanceTable(Recipe recipe) {
        super(recipe, "LST provenance", "Table showing which tools were used to produce LSTs.");
    }

    public static final class Row {
        @Column(displayName="Build tool type", description="The type of tool which produced the LST.")
        private final LstProvenance.Type buildToolType;
        @Column(displayName="Build tool version", description="The version of the build tool which produced the LST.")
        private final String buildToolVersion;
        @Column(displayName="LST serializer version", description="The version of LST serializer which produced the LST.")
        private final String lstSerializerVersion;
        @Column(displayName="Timestamp (epoch millis)", description="UTC timestamp describing when the LST was produced, in milliseconds since the unix epoch.")
        private final long timestampEpochMillis;
        @Column(displayName="Timestamp", description="UTC timestamp describing when the LST was produced, in ISO-8601 format. e.g.: \"2023\u201008\u201007T22:24:06+00:00 UTC+00:00\"")
        private final String timestampUtc;

        public Row(LstProvenance.Type buildToolType, String buildToolVersion, String lstSerializerVersion, long timestampEpochMillis, String timestampUtc) {
            this.buildToolType = buildToolType;
            this.buildToolVersion = buildToolVersion;
            this.lstSerializerVersion = lstSerializerVersion;
            this.timestampEpochMillis = timestampEpochMillis;
            this.timestampUtc = timestampUtc;
        }

        public LstProvenance.Type getBuildToolType() {
            return this.buildToolType;
        }

        public String getBuildToolVersion() {
            return this.buildToolVersion;
        }

        public String getLstSerializerVersion() {
            return this.lstSerializerVersion;
        }

        public long getTimestampEpochMillis() {
            return this.timestampEpochMillis;
        }

        public String getTimestampUtc() {
            return this.timestampUtc;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getTimestampEpochMillis() != other.getTimestampEpochMillis()) {
                return false;
            }
            LstProvenance.Type this$buildToolType = this.getBuildToolType();
            LstProvenance.Type other$buildToolType = other.getBuildToolType();
            if (this$buildToolType == null ? other$buildToolType != null : !((Object)((Object)this$buildToolType)).equals((Object)other$buildToolType)) {
                return false;
            }
            String this$buildToolVersion = this.getBuildToolVersion();
            String other$buildToolVersion = other.getBuildToolVersion();
            if (this$buildToolVersion == null ? other$buildToolVersion != null : !this$buildToolVersion.equals(other$buildToolVersion)) {
                return false;
            }
            String this$lstSerializerVersion = this.getLstSerializerVersion();
            String other$lstSerializerVersion = other.getLstSerializerVersion();
            if (this$lstSerializerVersion == null ? other$lstSerializerVersion != null : !this$lstSerializerVersion.equals(other$lstSerializerVersion)) {
                return false;
            }
            String this$timestampUtc = this.getTimestampUtc();
            String other$timestampUtc = other.getTimestampUtc();
            return !(this$timestampUtc == null ? other$timestampUtc != null : !this$timestampUtc.equals(other$timestampUtc));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestampEpochMillis = this.getTimestampEpochMillis();
            result = result * 59 + (int)($timestampEpochMillis >>> 32 ^ $timestampEpochMillis);
            LstProvenance.Type $buildToolType = this.getBuildToolType();
            result = result * 59 + ($buildToolType == null ? 43 : ((Object)((Object)$buildToolType)).hashCode());
            String $buildToolVersion = this.getBuildToolVersion();
            result = result * 59 + ($buildToolVersion == null ? 43 : $buildToolVersion.hashCode());
            String $lstSerializerVersion = this.getLstSerializerVersion();
            result = result * 59 + ($lstSerializerVersion == null ? 43 : $lstSerializerVersion.hashCode());
            String $timestampUtc = this.getTimestampUtc();
            result = result * 59 + ($timestampUtc == null ? 43 : $timestampUtc.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "LstProvenanceTable.Row(buildToolType=" + (Object)((Object)this.getBuildToolType()) + ", buildToolVersion=" + this.getBuildToolVersion() + ", lstSerializerVersion=" + this.getLstSerializerVersion() + ", timestampEpochMillis=" + this.getTimestampEpochMillis() + ", timestampUtc=" + this.getTimestampUtc() + ")";
        }
    }
}

