/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.LstProvenance;
import org.openrewrite.table.LstProvenanceTable;

public final class FindLstProvenance
extends ScanningRecipe<Accumulator> {
    private final transient LstProvenanceTable provenanceTable = new LstProvenanceTable(this);

    @Override
    public String getDisplayName() {
        return "Find LST provenance";
    }

    @Override
    public String getDescription() {
        return "Produces a data table showing what versions of OpenRewrite/Moderne tooling was used to produce a given LST. ";
    }

    @Override
    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                LstProvenance lstProvenance = tree.getMarkers().findFirst(LstProvenance.class).orElse(null);
                if (lstProvenance == null) {
                    return tree;
                }
                if (acc.seenProvenance.add(lstProvenance)) {
                    FindLstProvenance.this.provenanceTable.insertRow(ctx, new LstProvenanceTable.Row(lstProvenance.getBuildToolType(), lstProvenance.getBuildToolVersion(), lstProvenance.getLstSerializerVersion(), lstProvenance.getTimestampUtc().toEpochMilli(), lstProvenance.getTimestampUtc().atZone(ZoneOffset.UTC).toString()));
                }
                return tree;
            }
        };
    }

    public LstProvenanceTable getProvenanceTable() {
        return this.provenanceTable;
    }

    @NonNull
    public String toString() {
        return "FindLstProvenance(provenanceTable=" + this.getProvenanceTable() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindLstProvenance)) {
            return false;
        }
        FindLstProvenance other = (FindLstProvenance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindLstProvenance;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Accumulator {
        Set<LstProvenance> seenProvenance = new HashSet<LstProvenance>();
    }
}

