/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import java.util.Stack;
import org.openrewrite.Changeset;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class SourcesFileResults
extends DataTable<Row> {
    public SourcesFileResults(Recipe recipe) {
        super(recipe, "Source files that had results", "Source files that were modified by the recipe run.");
    }

    public static SourcesFileResults build(Changeset changeset, int cycle, ExecutionContext ctx) {
        SourcesFileResults resultsTable = new SourcesFileResults(Recipe.noop());
        for (Result result : changeset.getAllResults()) {
            Stack<RecipeDescriptor[]> recipeStack = new Stack<RecipeDescriptor[]>();
            for (RecipeDescriptor rd : result.getRecipeDescriptorsThatMadeChanges()) {
                recipeStack.push(new RecipeDescriptor[]{null, rd});
            }
            while (!recipeStack.isEmpty()) {
                RecipeDescriptor[] recipeThatMadeChange = (RecipeDescriptor[])recipeStack.pop();
                resultsTable.insertRow(ctx, new Row(result.getBefore() == null ? "" : result.getBefore().getSourcePath().toString(), result.getAfter() == null ? "" : result.getAfter().getSourcePath().toString(), recipeThatMadeChange[0] == null ? "" : recipeThatMadeChange[0].getName(), recipeThatMadeChange[1].getName(), result.getTimeSavings() == null ? 0L : result.getTimeSavings().getSeconds(), cycle));
                for (int i = recipeThatMadeChange[1].getRecipeList().size() - 1; i >= 0; --i) {
                    RecipeDescriptor rd = recipeThatMadeChange[1].getRecipeList().get(i);
                    recipeStack.push(new RecipeDescriptor[]{recipeThatMadeChange[1], rd});
                }
            }
        }
        return resultsTable;
    }

    public static final class Row {
        @Column(displayName="Source path before the run", description="The source path of the file before the run.")
        private final String sourcePath;
        @Column(displayName="Source path after the run", description="A recipe may modify the source path. This is the path after the run.")
        private final String afterSourcePath;
        @Column(displayName="Parent of the recipe that made changes", description="In a hierarchical recipe, the parent of the recipe that made a change. Empty ifthis is the root of a hierarchy or if the recipe is not hierarchical at all.")
        private final String parentRecipe;
        @Column(displayName="Recipe that made changes", description="The specific recipe that made a change.")
        private final String recipe;
        @Column(displayName="Estimated time saving", description="An estimated effort that a developer to fix manually instead of using this recipe, in unit of seconds.")
        private final Long estimatedTimeSaving;
        @Column(displayName="Cycle", description="The recipe cycle in which the change was made.")
        private final int cycle;

        public Row(String sourcePath, String afterSourcePath, String parentRecipe, String recipe, Long estimatedTimeSaving, int cycle) {
            this.sourcePath = sourcePath;
            this.afterSourcePath = afterSourcePath;
            this.parentRecipe = parentRecipe;
            this.recipe = recipe;
            this.estimatedTimeSaving = estimatedTimeSaving;
            this.cycle = cycle;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getAfterSourcePath() {
            return this.afterSourcePath;
        }

        public String getParentRecipe() {
            return this.parentRecipe;
        }

        public String getRecipe() {
            return this.recipe;
        }

        public Long getEstimatedTimeSaving() {
            return this.estimatedTimeSaving;
        }

        public int getCycle() {
            return this.cycle;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getCycle() != other.getCycle()) {
                return false;
            }
            Long this$estimatedTimeSaving = this.getEstimatedTimeSaving();
            Long other$estimatedTimeSaving = other.getEstimatedTimeSaving();
            if (this$estimatedTimeSaving == null ? other$estimatedTimeSaving != null : !((Object)this$estimatedTimeSaving).equals(other$estimatedTimeSaving)) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$afterSourcePath = this.getAfterSourcePath();
            String other$afterSourcePath = other.getAfterSourcePath();
            if (this$afterSourcePath == null ? other$afterSourcePath != null : !this$afterSourcePath.equals(other$afterSourcePath)) {
                return false;
            }
            String this$parentRecipe = this.getParentRecipe();
            String other$parentRecipe = other.getParentRecipe();
            if (this$parentRecipe == null ? other$parentRecipe != null : !this$parentRecipe.equals(other$parentRecipe)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCycle();
            Long $estimatedTimeSaving = this.getEstimatedTimeSaving();
            result = result * 59 + ($estimatedTimeSaving == null ? 43 : ((Object)$estimatedTimeSaving).hashCode());
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $afterSourcePath = this.getAfterSourcePath();
            result = result * 59 + ($afterSourcePath == null ? 43 : $afterSourcePath.hashCode());
            String $parentRecipe = this.getParentRecipe();
            result = result * 59 + ($parentRecipe == null ? 43 : $parentRecipe.hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "SourcesFileResults.Row(sourcePath=" + this.getSourcePath() + ", afterSourcePath=" + this.getAfterSourcePath() + ", parentRecipe=" + this.getParentRecipe() + ", recipe=" + this.getRecipe() + ", estimatedTimeSaving=" + this.getEstimatedTimeSaving() + ", cycle=" + this.getCycle() + ")";
        }
    }
}

