/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.LstProvenance;

@JsonIgnoreType
public class LstProvenanceTable
extends DataTable<Row> {
    public LstProvenanceTable(Recipe recipe) {
        super(recipe, "LST Provenance", "Table showing which tools were used to produce LSTs.");
    }

    public static final class Row {
        @Column(displayName="Build tool type", description="The type of tool which produced the LST.")
        private final LstProvenance.Type buildToolType;
        @Column(displayName="Build tool version", description="The version of the build tool which produced the LST.")
        private final String buildToolVersion;
        @Column(displayName="LST serializer version", description="The version of LST serializer which produced the LST.")
        private final String lstSerializerVersion;

        public Row(LstProvenance.Type buildToolType, String buildToolVersion, String lstSerializerVersion) {
            this.buildToolType = buildToolType;
            this.buildToolVersion = buildToolVersion;
            this.lstSerializerVersion = lstSerializerVersion;
        }

        public LstProvenance.Type getBuildToolType() {
            return this.buildToolType;
        }

        public String getBuildToolVersion() {
            return this.buildToolVersion;
        }

        public String getLstSerializerVersion() {
            return this.lstSerializerVersion;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            LstProvenance.Type this$buildToolType = this.getBuildToolType();
            LstProvenance.Type other$buildToolType = other.getBuildToolType();
            if (this$buildToolType == null ? other$buildToolType != null : !((Object)((Object)this$buildToolType)).equals((Object)other$buildToolType)) {
                return false;
            }
            String this$buildToolVersion = this.getBuildToolVersion();
            String other$buildToolVersion = other.getBuildToolVersion();
            if (this$buildToolVersion == null ? other$buildToolVersion != null : !this$buildToolVersion.equals(other$buildToolVersion)) {
                return false;
            }
            String this$lstSerializerVersion = this.getLstSerializerVersion();
            String other$lstSerializerVersion = other.getLstSerializerVersion();
            return !(this$lstSerializerVersion == null ? other$lstSerializerVersion != null : !this$lstSerializerVersion.equals(other$lstSerializerVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LstProvenance.Type $buildToolType = this.getBuildToolType();
            result = result * 59 + ($buildToolType == null ? 43 : ((Object)((Object)$buildToolType)).hashCode());
            String $buildToolVersion = this.getBuildToolVersion();
            result = result * 59 + ($buildToolVersion == null ? 43 : $buildToolVersion.hashCode());
            String $lstSerializerVersion = this.getLstSerializerVersion();
            result = result * 59 + ($lstSerializerVersion == null ? 43 : $lstSerializerVersion.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "LstProvenanceTable.Row(buildToolType=" + (Object)((Object)this.getBuildToolType()) + ", buildToolVersion=" + this.getBuildToolVersion() + ", lstSerializerVersion=" + this.getLstSerializerVersion() + ")";
        }
    }
}

