/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.LatestRelease;

public class TildeRange
extends LatestRelease {
    private static final Pattern TILDE_RANGE_PATTERN = Pattern.compile("~(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?");
    private final String upperExclusive;
    private final String lower;

    private TildeRange(String lower, String upperExclusive, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.lower = lower;
        this.upperExclusive = upperExclusive;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return super.isValid(currentVersion, version) && super.compare(currentVersion, version, this.upperExclusive) < 0 && super.compare(currentVersion, version, this.lower) >= 0;
    }

    public static Validated<TildeRange> build(String pattern, @Nullable String metadataPattern) {
        String upper;
        String lower;
        Matcher matcher = TILDE_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("tildeRange", pattern, "not a tilde range");
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        String patch = matcher.group(3);
        String micro = matcher.group(4);
        if (minor == null) {
            lower = major;
            upper = Integer.toString(Integer.parseInt(major) + 1);
        } else if (patch == null) {
            lower = major + "." + minor;
            upper = major + "." + (Integer.parseInt(minor) + 1);
        } else if (micro == null) {
            lower = major + "." + minor + "." + patch;
            upper = major + "." + (Integer.parseInt(minor) + 1);
        } else {
            lower = major + "." + minor + "." + patch + "." + micro;
            upper = major + "." + minor + "." + (Integer.parseInt(patch) + 1);
        }
        return Validated.valid("tildeRange", new TildeRange(lower, upper, metadataPattern));
    }
}

