/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.scheduling;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;

public class WatchableExecutionContext
implements ExecutionContext {
    private final ExecutionContext delegate;
    private boolean hasNewMessages = false;

    public boolean hasNewMessages() {
        return this.hasNewMessages;
    }

    public void resetHasNewMessages() {
        this.hasNewMessages = false;
    }

    @Override
    public void putMessage(String key, @Nullable Object value) {
        this.hasNewMessages = true;
        this.delegate.putMessage(key, value);
    }

    public void putCycle(int cycle) {
        this.delegate.putMessage("org.openrewrite.currentCycle", cycle);
    }

    @Override
    @Nullable
    public <T> T getMessage(String key) {
        return this.delegate.getMessage(key);
    }

    @Override
    @Nullable
    public <T> T pollMessage(String key) {
        return this.delegate.pollMessage(key);
    }

    @Override
    public Consumer<Throwable> getOnError() {
        return this.delegate.getOnError();
    }

    @Override
    public BiConsumer<Throwable, ExecutionContext> getOnTimeout() {
        return this.delegate.getOnTimeout();
    }

    public WatchableExecutionContext(ExecutionContext delegate) {
        this.delegate = delegate;
    }
}

