/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.openrewrite.Contributor;
import org.openrewrite.Maintainer;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RecipeDescriptor {
    private final String name;
    private final String displayName;
    private final String description;
    private final Set<String> tags;
    @Nullable
    private final Duration estimatedEffortPerOccurrence;
    private final List<OptionDescriptor> options;
    private final List<RecipeDescriptor> recipeList;
    private final List<DataTableDescriptor> dataTables;
    private final List<Maintainer> maintainers;
    private final List<Contributor> contributors;
    private final List<RecipeExample> examples;
    private final URI source;

    public RecipeDescriptor(String name, String displayName, String description, Set<String> tags, @Nullable Duration estimatedEffortPerOccurrence, List<OptionDescriptor> options, List<RecipeDescriptor> recipeList, List<DataTableDescriptor> dataTables, List<Maintainer> maintainers, List<Contributor> contributors, List<RecipeExample> examples, URI source) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.options = options;
        this.recipeList = recipeList;
        this.dataTables = dataTables;
        this.maintainers = maintainers;
        this.contributors = contributors;
        this.examples = examples;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    public List<OptionDescriptor> getOptions() {
        return this.options;
    }

    public List<RecipeDescriptor> getRecipeList() {
        return this.recipeList;
    }

    public List<DataTableDescriptor> getDataTables() {
        return this.dataTables;
    }

    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    public List<Contributor> getContributors() {
        return this.contributors;
    }

    public List<RecipeExample> getExamples() {
        return this.examples;
    }

    public URI getSource() {
        return this.source;
    }

    @NonNull
    public String toString() {
        return "RecipeDescriptor(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ", options=" + this.getOptions() + ", recipeList=" + this.getRecipeList() + ", dataTables=" + this.getDataTables() + ", maintainers=" + this.getMaintainers() + ", contributors=" + this.getContributors() + ", examples=" + this.getExamples() + ", source=" + this.getSource() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeDescriptor)) {
            return false;
        }
        RecipeDescriptor other = (RecipeDescriptor)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<OptionDescriptor> this$options = this.getOptions();
        List<OptionDescriptor> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<OptionDescriptor> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    @NonNull
    public RecipeDescriptor withRecipeList(List<RecipeDescriptor> recipeList) {
        return this.recipeList == recipeList ? this : new RecipeDescriptor(this.name, this.displayName, this.description, this.tags, this.estimatedEffortPerOccurrence, this.options, recipeList, this.dataTables, this.maintainers, this.contributors, this.examples, this.source);
    }

    @NonNull
    public RecipeDescriptor withDataTables(List<DataTableDescriptor> dataTables) {
        return this.dataTables == dataTables ? this : new RecipeDescriptor(this.name, this.displayName, this.description, this.tags, this.estimatedEffortPerOccurrence, this.options, this.recipeList, dataTables, this.maintainers, this.contributors, this.examples, this.source);
    }
}

