/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.remote.RemoteArtifactCache;

public class LocalRemoteArtifactCache
implements RemoteArtifactCache {
    private final Path cacheDir;

    public LocalRemoteArtifactCache(Path cacheDir) {
        if (!cacheDir.toFile().exists() && !cacheDir.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to find or create remote archive cache at " + cacheDir);
        }
        this.cacheDir = cacheDir;
    }

    @Override
    @Nullable
    public Path get(URI uri) {
        Path resolved = this.cacheDir.resolve(LocalRemoteArtifactCache.hashUri(uri));
        return Files.exists(resolved, new LinkOption[0]) ? resolved : null;
    }

    @Override
    @Nullable
    public Path put(URI uri, InputStream artifactInputStream, Consumer<Throwable> onError) {
        try {
            Path artifact = this.cacheDir.resolve(LocalRemoteArtifactCache.hashUri(uri) + ".tmp");
            try (InputStream is = artifactInputStream;){
                Files.copy(is, artifact, StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(artifact, this.cacheDir.resolve(LocalRemoteArtifactCache.hashUri(uri)), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            return this.cacheDir.resolve(LocalRemoteArtifactCache.hashUri(uri));
        }
        catch (Exception e) {
            onError.accept(e);
            return null;
        }
    }

    public static String hashUri(URI uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(uri.toString().getBytes(StandardCharsets.UTF_8));
            StringBuilder hashStringBuilder = new StringBuilder();
            for (byte hashByte : hashBytes) {
                String hex = Integer.toHexString(0xFF & hashByte);
                if (hex.length() == 1) {
                    hashStringBuilder.append('0');
                }
                hashStringBuilder.append(hex);
            }
            return hashStringBuilder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

