/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public final class ParseError
implements SourceFile {
    private final UUID id;
    private final Markers markers;
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    @Nullable
    private final String charsetName;
    private final boolean charsetBomMarked;
    @Nullable
    private final Checksum checksum;
    private final String text;

    @Override
    public Charset getCharset() {
        return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
    }

    public SourceFile withCharset(Charset charset) {
        return this.withCharsetName(charset.name());
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return true;
    }

    public static ParseError build(Parser parser, Parser.Input input, @Nullable Path relativeTo, ExecutionContext ctx, Throwable t) {
        EncodingDetectingInputStream is = input.getSource(ctx);
        return new ParseError(Tree.randomId(), new Markers(Tree.randomId(), Collections.singletonList(ParseExceptionResult.build(parser, t))), input.getRelativePath(relativeTo), input.getFileAttributes(), parser.getCharset(ctx).name(), is.isCharsetBomMarked(), null, is.readFully());
    }

    public ParseError(UUID id, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, String text) {
        this.id = id;
        this.markers = markers;
        this.sourcePath = sourcePath;
        this.fileAttributes = fileAttributes;
        this.charsetName = charsetName;
        this.charsetBomMarked = charsetBomMarked;
        this.checksum = checksum;
        this.text = text;
    }

    @Nullable
    public String getCharsetName() {
        return this.charsetName;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseError)) {
            return false;
        }
        ParseError other = (ParseError)o;
        if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        FileAttributes this$fileAttributes = this.getFileAttributes();
        FileAttributes other$fileAttributes = other.getFileAttributes();
        if (this$fileAttributes == null ? other$fileAttributes != null : !((Object)this$fileAttributes).equals(other$fileAttributes)) {
            return false;
        }
        String this$charsetName = this.getCharsetName();
        String other$charsetName = other.getCharsetName();
        if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
            return false;
        }
        Checksum this$checksum = this.getChecksum();
        Checksum other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        FileAttributes $fileAttributes = this.getFileAttributes();
        result = result * 59 + ($fileAttributes == null ? 43 : ((Object)$fileAttributes).hashCode());
        String $charsetName = this.getCharsetName();
        result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
        Checksum $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "ParseError(id=" + this.getId() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", text=" + this.getText() + ")";
    }

    @NonNull
    public ParseError withId(UUID id) {
        return this.id == id ? this : new ParseError(id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @NonNull
    public ParseError withMarkers(Markers markers) {
        return this.markers == markers ? this : new ParseError(this.id, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text);
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    @NonNull
    public ParseError withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new ParseError(this.id, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text);
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @NonNull
    public ParseError withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new ParseError(this.id, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text);
    }

    @Override
    @Nullable
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @NonNull
    private ParseError withCharsetName(@Nullable String charsetName) {
        return this.charsetName == charsetName ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.text);
    }

    @NonNull
    public ParseError withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.text);
    }

    @Override
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @NonNull
    public ParseError withChecksum(@Nullable Checksum checksum) {
        return this.checksum == checksum ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.text);
    }

    @Override
    @Nullable
    public Checksum getChecksum() {
        return this.checksum;
    }

    @NonNull
    public ParseError withText(String text) {
        return this.text == text ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, text);
    }
}

