/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PlainTextParser
implements Parser<PlainText> {
    public static PlainText convert(SourceFile sourceFile) {
        if (sourceFile instanceof PlainText) {
            return (PlainText)sourceFile;
        }
        PlainText text = (PlainText)((SourceFile)PlainTextParser.builder().build().parse(sourceFile.printAll()).findFirst().orElseThrow(() -> new IllegalStateException("Failed to parse as plain text"))).withSourcePath(sourceFile.getSourcePath()).withFileAttributes(sourceFile.getFileAttributes()).withCharsetBomMarked(sourceFile.isCharsetBomMarked()).withId(sourceFile.getId());
        if (sourceFile.getCharset() != null) {
            text = (PlainText)text.withCharset(sourceFile.getCharset());
        }
        return text;
    }

    @Override
    public Stream<PlainText> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view(ctx).getParsingListener();
        return StreamSupport.stream(sources.spliterator(), false).map(source -> {
            Path path = source.getRelativePath(relativeTo);
            try {
                EncodingDetectingInputStream is = source.getSource(ctx);
                String sourceStr = is.readFully();
                PlainText plainText = new PlainText(Tree.randomId(), path, Markers.EMPTY, is.getCharset().name(), is.isCharsetBomMarked(), source.getFileAttributes(), null, sourceStr, null);
                parsingListener.parsed((Parser.Input)source, plainText);
                return plainText;
            }
            catch (Throwable t) {
                ParsingExecutionContextView.view(ctx).parseFailure((Parser.Input)source, relativeTo, this, t);
                ctx.getOnError().accept(t);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.txt");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(PlainText.class);
        }

        @Override
        public Parser<?> build() {
            return new PlainTextParser();
        }

        @Override
        public String getDslName() {
            return "text";
        }
    }
}

