/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.text.PlainTextVisitor;

public final class CreateTextFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="File contents", description="Multiline text content for the file.", example="Some text.")
    private final String fileContents;
    @Option(displayName="Relative file path", description="File path of new file.", example="foo/bar/baz.txt")
    private final String relativeFileName;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    @Nullable
    private final Boolean overwriteExisting;

    @Override
    public String getDisplayName() {
        return "Create text file";
    }

    @Override
    public String getDescription() {
        return "Creates a new plain text file.";
    }

    @Override
    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean shouldCreate) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (path.toString().equals(sourceFile.getSourcePath().toString())) {
                    shouldCreate.set(false);
                }
                return sourceFile;
            }
        };
    }

    @Override
    public Collection<PlainText> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return new PlainTextParser().parse(this.fileContents).map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new PlainTextVisitor<ExecutionContext>(){

            @Override
            @Nullable
            public PlainText visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (created.get()) {
                    return (PlainText)tree;
                }
                return (PlainText)super.visit(tree, executionContext);
            }

            @Override
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                if (path.toString().equals(text.getSourcePath().toString()) && Boolean.TRUE.equals(CreateTextFile.this.overwriteExisting)) {
                    return text.withText(CreateTextFile.this.fileContents);
                }
                return text;
            }
        };
    }

    public CreateTextFile(String fileContents, String relativeFileName, @Nullable Boolean overwriteExisting) {
        this.fileContents = fileContents;
        this.relativeFileName = relativeFileName;
        this.overwriteExisting = overwriteExisting;
    }

    public String getFileContents() {
        return this.fileContents;
    }

    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Nullable
    public Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @NonNull
    public String toString() {
        return "CreateTextFile(fileContents=" + this.getFileContents() + ", relativeFileName=" + this.getRelativeFileName() + ", overwriteExisting=" + this.getOverwriteExisting() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTextFile)) {
            return false;
        }
        CreateTextFile other = (CreateTextFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        if (this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        return !(this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CreateTextFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        return result;
    }
}

