/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Contributor;
import org.openrewrite.Maintainer;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class DeclarativeRecipe
extends Recipe {
    private final String name;
    @Language(value="markdown")
    private final String displayName;
    @Language(value="markdown")
    private final String description;
    private final Set<String> tags;
    @Nullable
    private final Duration estimatedEffortPerOccurrence;
    private final URI source;
    private final boolean causesAnotherCycle;
    private final List<Maintainer> maintainers;
    private final List<Recipe> uninitializedRecipes = new ArrayList<Recipe>();
    private final List<Recipe> recipeList = new ArrayList<Recipe>();
    @JsonIgnore
    private Validated validation = Validated.test("initialization", "initialize(..) must be called on DeclarativeRecipe prior to use.", this, r -> this.uninitializedRecipes.isEmpty());

    @Override
    public boolean causesAnotherCycle() {
        return this.causesAnotherCycle || super.causesAnotherCycle();
    }

    @Override
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence == null ? super.getEstimatedEffortPerOccurrence() : this.estimatedEffortPerOccurrence;
    }

    public void initialize(Collection<Recipe> availableRecipes, Map<String, List<Contributor>> recipeToContributors) {
        for (int i = 0; i < this.uninitializedRecipes.size(); ++i) {
            Recipe recipe = this.uninitializedRecipes.get(i);
            if (recipe instanceof LazyLoadedRecipe) {
                String recipeFqn = ((LazyLoadedRecipe)recipe).getRecipeFqn();
                Optional<Recipe> next = availableRecipes.stream().filter(r -> r.getName().equals(recipeFqn)).findAny();
                if (next.isPresent()) {
                    this.recipeList.add(next.get());
                    continue;
                }
                this.validation = this.validation.and(Validated.invalid(this.name + ".recipeList[" + i + "] (in " + this.source + ")", recipeFqn, "recipe '" + recipeFqn + "' does not exist.", null));
                continue;
            }
            recipe.setContributors(recipeToContributors.getOrDefault(recipe.getName(), Collections.emptyList()));
            this.recipeList.add(recipe);
        }
        this.uninitializedRecipes.clear();
    }

    @Override
    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    public void addUninitialized(Recipe recipe) {
        this.uninitializedRecipes.add(recipe);
    }

    public void addUninitialized(String recipeName, @Nullable ClassLoader classLoader) {
        try {
            this.uninitializedRecipes.add((Recipe)Class.forName(recipeName, true, classLoader != null ? classLoader : this.getClass().getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            this.uninitializedRecipes.add(new LazyLoadedRecipe(recipeName));
        }
    }

    public void addValidation(Validated validated) {
        this.validation = this.validation.and(validated);
    }

    @Override
    public Validated validate() {
        return this.validation;
    }

    @Override
    protected RecipeDescriptor createRecipeDescriptor() {
        ArrayList<RecipeDescriptor> recipeList = new ArrayList<RecipeDescriptor>();
        for (Recipe childRecipe : this.getRecipeList()) {
            recipeList.add(childRecipe.getDescriptor());
        }
        return new RecipeDescriptor(this.getName(), this.getDisplayName(), this.getDescription(), this.getTags(), this.getEstimatedEffortPerOccurrence(), Collections.emptyList(), recipeList, this.getDataTableDescriptors(), this.getMaintainers(), this.getContributors(), this.getExamples(), this.source);
    }

    @Override
    public List<Contributor> getContributors() {
        if (this.contributors == null) {
            HashMap<NameEmail, Integer> contributorToLineCount = new HashMap<NameEmail, Integer>();
            this.contributors = new ArrayList();
            for (Recipe recipe : this.getRecipeList()) {
                for (Contributor contributor : recipe.getContributors()) {
                    NameEmail nameEmail = new NameEmail(contributor.getName(), contributor.getEmail());
                    contributorToLineCount.put(nameEmail, contributorToLineCount.getOrDefault(nameEmail, 0) + contributor.getLineCount());
                }
            }
            for (Map.Entry entry : contributorToLineCount.entrySet()) {
                this.contributors.add(new Contributor(((NameEmail)entry.getKey()).getName(), ((NameEmail)entry.getKey()).getEmail(), (Integer)entry.getValue()));
            }
            this.contributors.sort(Comparator.comparing(Contributor::getLineCount).reversed());
        }
        return this.contributors;
    }

    public DeclarativeRecipe(String name, @Language(value="markdown") String displayName, @Language(value="markdown") String description, Set<String> tags, @Nullable Duration estimatedEffortPerOccurrence, URI source, boolean causesAnotherCycle, List<Maintainer> maintainers) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.source = source;
        this.causesAnotherCycle = causesAnotherCycle;
        this.maintainers = maintainers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Language(value="markdown")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    private static final class LazyLoadedRecipe
    extends Recipe {
        private final String recipeFqn;

        @Override
        public String getDisplayName() {
            return "Lazy loaded recipe";
        }

        @Override
        public String getDescription() {
            return "Recipe that is loaded lazily.";
        }

        public LazyLoadedRecipe(String recipeFqn) {
            this.recipeFqn = recipeFqn;
        }

        public String getRecipeFqn() {
            return this.recipeFqn;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.LazyLoadedRecipe(recipeFqn=" + this.getRecipeFqn() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LazyLoadedRecipe)) {
                return false;
            }
            LazyLoadedRecipe other = (LazyLoadedRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$recipeFqn = this.getRecipeFqn();
            String other$recipeFqn = other.getRecipeFqn();
            return !(this$recipeFqn == null ? other$recipeFqn != null : !this$recipeFqn.equals(other$recipeFqn));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof LazyLoadedRecipe;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $recipeFqn = this.getRecipeFqn();
            result = result * 59 + ($recipeFqn == null ? 43 : $recipeFqn.hashCode());
            return result;
        }
    }

    private static final class NameEmail {
        private final String name;
        private final String email;

        public NameEmail(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameEmail)) {
                return false;
            }
            NameEmail other = (NameEmail)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.NameEmail(name=" + this.getName() + ", email=" + this.getEmail() + ")";
        }
    }
}

