/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import io.micrometer.core.instrument.Timer;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;

public class MetricsHelper {
    public static Timer.Builder successTags(Timer.Builder timer, String detailedOutcome) {
        return MetricsHelper.successTags(timer, null, detailedOutcome);
    }

    public static Timer.Builder successTags(Timer.Builder timer) {
        return MetricsHelper.successTags(timer, "success");
    }

    public static <S extends SourceFile> Timer.Builder successTags(Timer.Builder timer, @Nullable S sourceFile) {
        return MetricsHelper.successTags(timer, sourceFile, "success");
    }

    public static <S extends SourceFile> Timer.Builder successTags(Timer.Builder timer, @Nullable S sourceFile, String detailedOutcome) {
        String originRepository = MetricsHelper.getOriginRepository(sourceFile);
        return timer.tag("outcome", detailedOutcome).tag("exception", "none").tag("exception.line", "none").tag("exception.declaring.class", "none").tag("step", "none").tag("repo.id", originRepository);
    }

    public static Timer.Builder errorTags(Timer.Builder timer, Throwable t) {
        return MetricsHelper.errorTags(timer, null, t);
    }

    public static <S extends SourceFile> Timer.Builder errorTags(Timer.Builder timer, @Nullable S sourceFile, Throwable t) {
        String originRepository = MetricsHelper.getOriginRepository(sourceFile);
        StackTraceElement stackTraceElement = null;
        if (t.getStackTrace().length > 0) {
            stackTraceElement = t.getStackTrace()[0];
        }
        String exceptionLine = "none";
        String exceptionDeclaringClass = "none";
        if (stackTraceElement != null) {
            exceptionLine = Integer.toString(stackTraceElement.getLineNumber());
            exceptionDeclaringClass = stackTraceElement.getClassName();
        }
        return timer.tag("outcome", "error").tag("exception", t.getClass().getSimpleName()).tag("step", "none").tag("repo.id", originRepository).tag("exception.line", exceptionLine).tag("exception.declaring.class", exceptionDeclaringClass);
    }

    @NotNull
    private static <S extends SourceFile> String getOriginRepository(@Nullable S sourceFile) {
        GitProvenance gitProvenance;
        String origin;
        Optional<GitProvenance> maybeGitProvenance;
        String originRepository = "none";
        if (sourceFile != null && (maybeGitProvenance = sourceFile.getMarkers().findFirst(GitProvenance.class)).isPresent() && (origin = (gitProvenance = maybeGitProvenance.get()).getOrigin()) != null) {
            originRepository = origin;
        }
        return originRepository;
    }
}

