/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.util.UUID;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainTextVisitor;

public final class PlainText
implements SourceFile,
Tree {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final String text;

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof PlainTextVisitor;
    }

    @Override
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)((PlainTextVisitor)v).visitText(this, p);
    }

    @Override
    public <P> String print(TreePrinter<P> printer, P p) {
        return this.print(p);
    }

    @Override
    public <P> String print(P p) {
        return this.text;
    }

    public PlainText(UUID id, Path sourcePath, Markers markers, String text) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.text = text;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlainText)) {
            return false;
        }
        PlainText other = (PlainText)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "PlainText(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
    }

    @Override
    @NonNull
    public PlainText withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new PlainText(this.id, sourcePath, this.markers, this.text);
    }

    @NonNull
    public PlainText withMarkers(Markers markers) {
        return this.markers == markers ? this : new PlainText(this.id, this.sourcePath, markers, this.text);
    }

    @NonNull
    public PlainText withText(String text) {
        return this.text == text ? this : new PlainText(this.id, this.sourcePath, this.markers, text);
    }
}

