/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class StringUtils {
    private StringUtils() {
    }

    public static String trimIndent(String text) {
        int indentLevel = StringUtils.indentLevel(text);
        StringBuilder trimmed = new StringBuilder();
        AtomicBoolean dropWhile = new AtomicBoolean(false);
        int[] charArray = text.replaceAll("\\s+$", "").chars().filter(c -> {
            dropWhile.set(dropWhile.get() || c != 10 && c != 13);
            return dropWhile.get();
        }).toArray();
        for (int i = 0; i < charArray.length; ++i) {
            int j;
            boolean nonWhitespaceEncountered = false;
            for (j = i; j < charArray.length; ++j) {
                int c2 = charArray[j];
                if (j - i >= indentLevel || (nonWhitespaceEncountered |= !Character.isWhitespace(c2))) {
                    trimmed.append((char)c2);
                }
                if (c2 == 13 || c2 == 10) break;
            }
            i = j;
        }
        return trimmed.toString();
    }

    static int indentLevel(String text) {
        Stream<String> lines = Arrays.stream(text.replaceAll("\\s+$", "").split("\\r?\\n"));
        AtomicBoolean dropWhile = new AtomicBoolean(false);
        AtomicBoolean takeWhile = new AtomicBoolean(true);
        SortedMap indentFrequencies = lines.filter(l -> {
            dropWhile.set(dropWhile.get() || !l.isEmpty());
            return dropWhile.get();
        }).map(l -> {
            takeWhile.set(true);
            return (int)l.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                return takeWhile.get();
            }).count();
        }).collect(Collectors.groupingBy(Function.identity(), TreeMap::new, Collectors.counting()));
        return StringUtils.mostCommonIndent(indentFrequencies);
    }

    public static int mostCommonIndent(SortedMap<Integer, Long> indentFrequencies) {
        TreeMap<Integer, Integer> indentFrequencyAsDivisors = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Long> indentFrequency : indentFrequencies.entrySet()) {
            int freq;
            int indent = indentFrequency.getKey();
            switch (indent) {
                case 0: {
                    freq = indentFrequency.getValue().intValue();
                    break;
                }
                case 1: {
                    freq = (int)indentFrequencies.tailMap(indent).values().stream().mapToLong(l -> l).sum();
                    break;
                }
                default: {
                    freq = (int)indentFrequencies.tailMap(indent).entrySet().stream().filter(inF -> StringUtils.gcd((Integer)inF.getKey(), indent) != 0).mapToLong(Map.Entry::getValue).sum();
                }
            }
            indentFrequencyAsDivisors.put(indent, freq);
        }
        if (indentFrequencies.getOrDefault(0, 0L) > 1L) {
            return 0;
        }
        return indentFrequencyAsDivisors.entrySet().stream().max((e1, e2) -> {
            int valCompare = ((Integer)e1.getValue()).compareTo((Integer)e2.getValue());
            return valCompare != 0 ? valCompare : ((Integer)e1.getKey() == 0 ? -1 : ((Integer)e2.getKey()).compareTo((Integer)e1.getKey()));
        }).map(Map.Entry::getKey).orElse(0);
    }

    static int gcd(int n1, int n2) {
        return n2 == 0 ? n1 : StringUtils.gcd(n2, n1 % n2);
    }

    public static boolean isBlank(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String readFully(InputStream inputStream) {
        String string;
        block9: {
            InputStream is = inputStream;
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((n = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, n);
                }
                byte[] bytes = bos.toByteArray();
                string = new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String capitalize(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    public static String uncapitalize(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }

    public static List<String> splitCStyleComments(String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (text == null || text.equals("")) {
            result.add("");
            return result;
        }
        int segmentStartIndex = 0;
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        for (int i = 0; i < text.length(); ++i) {
            char previous;
            char current = text.charAt(i);
            char c = previous = i > 0 ? text.charAt(i - 1) : (char)'\u0000';
            if (i == text.length() - 1) {
                result.add(text.substring(segmentStartIndex, i + 1));
                break;
            }
            if (inSingleLineComment && current == '\n') {
                result.add(text.substring(segmentStartIndex, i));
                segmentStartIndex = i;
                inSingleLineComment = false;
                continue;
            }
            if (inMultiLineComment && previous == '*' && current == '/') {
                result.add(text.substring(segmentStartIndex, i + 1));
                segmentStartIndex = i + 1;
                inMultiLineComment = false;
                continue;
            }
            if (!inMultiLineComment && !inSingleLineComment && previous == '/' && current == '/') {
                inSingleLineComment = true;
                continue;
            }
            if (inMultiLineComment || inSingleLineComment || previous != '/' || current != '*') continue;
            inMultiLineComment = true;
        }
        return result;
    }

    public static String ensureNewlineCountBeforeComment(String text, int desiredNewlineCount) {
        String suffix;
        StringBuilder result = new StringBuilder();
        int prefixEndsIndex = StringUtils.indexOfNonWhitespace(text);
        if (prefixEndsIndex == -1) {
            prefixEndsIndex = text.length();
            suffix = "";
        } else {
            suffix = text.substring(prefixEndsIndex);
        }
        int newlinesSoFar = 0;
        for (int i = prefixEndsIndex - 1; i >= 0 && newlinesSoFar < desiredNewlineCount; --i) {
            char current = text.charAt(i);
            if (current == '\n') {
                ++newlinesSoFar;
            }
            result.append(current);
        }
        while (newlinesSoFar < desiredNewlineCount) {
            result.append('\n');
            ++newlinesSoFar;
        }
        result.reverse();
        result.append(suffix);
        return result.toString();
    }

    public static int indexOfNonWhitespace(String text) {
        return StringUtils.indexOf(text, it -> it.charValue() != ' ' && it.charValue() != '\t' && it.charValue() != '\n' && it.charValue() != '\r');
    }

    public static int indexOf(String text, Predicate<Character> test) {
        for (int i = 0; i < text.length(); ++i) {
            if (!test.test(Character.valueOf(text.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    public static int countOccurrences(@NonNull String text, @NonNull String substring) {
        if (text.isEmpty() || substring.isEmpty()) {
            return 0;
        }
        int count = 0;
        int index = text.indexOf(substring);
        while (index >= 0) {
            ++count;
            index = text.indexOf(substring, index + substring.length());
        }
        return count;
    }

    public static String replaceFirst(@NonNull String text, @NonNull String match, @NonNull String replacement) {
        int start = text.indexOf(match);
        if (match.isEmpty() || text.isEmpty() || start == -1) {
            return text;
        }
        StringBuilder newValue = new StringBuilder(text.length());
        newValue.append(text, 0, start);
        newValue.append(replacement);
        int end = start + match.length();
        if (end < text.length()) {
            newValue.append(text, end, text.length());
        }
        return newValue.toString();
    }
}

