/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeIntrospectionException;
import org.openrewrite.internal.lang.Nullable;

public class RecipeIntrospectionUtils {
    @Nullable
    public static TreeVisitor<?, ExecutionContext> recipeApplicableTest(Recipe recipe) {
        try {
            Method getVisitor = recipe.getClass().getDeclaredMethod("getApplicableTest", new Class[0]);
            getVisitor.setAccessible(true);
            return (TreeVisitor)getVisitor.invoke((Object)recipe, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return null;
        }
    }

    @Nullable
    public static TreeVisitor<?, ExecutionContext> recipeSingleSourceApplicableTest(Recipe recipe) {
        try {
            Method getVisitor = recipe.getClass().getDeclaredMethod("getSingleSourceApplicableTest", new Class[0]);
            getVisitor.setAccessible(true);
            return (TreeVisitor)getVisitor.invoke((Object)recipe, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return null;
        }
    }

    public static TreeVisitor<?, ExecutionContext> recipeVisitor(Recipe recipe) {
        try {
            Method getVisitor = recipe.getClass().getDeclaredMethod("getVisitor", new Class[0]);
            getVisitor.setAccessible(true);
            return (TreeVisitor)getVisitor.invoke((Object)recipe, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return Recipe.NOOP;
        }
    }

    public static RecipeDescriptor recipeDescriptorFromRecipeClass(Class<?> recipeClass) {
        URI recipeSource;
        List<OptionDescriptor> options = RecipeIntrospectionUtils.getOptionDescriptors(recipeClass);
        Recipe recipe = RecipeIntrospectionUtils.constructRecipe(recipeClass);
        try {
            recipeSource = recipeClass.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        RecipeDescriptor recipeDescriptor = new RecipeDescriptor(recipeClass.getName(), recipe.getDisplayName(), recipe.getDescription(), recipe.getTags(), options, recipe.getLanguages(), Collections.emptyList(), recipeSource);
        ArrayList<RecipeDescriptor> recipeList = new ArrayList<RecipeDescriptor>();
        for (Recipe next : recipe.getRecipeList()) {
            recipeList.add(RecipeIntrospectionUtils.recipeDescriptorFromRecipe(next));
        }
        return recipeDescriptor.withRecipeList(recipeList);
    }

    public static RecipeDescriptor recipeDescriptorFromDeclarativeRecipe(DeclarativeRecipe recipe, URI source) {
        ArrayList<RecipeDescriptor> recipeList = new ArrayList<RecipeDescriptor>();
        for (Recipe childRecipe : recipe.getRecipeList()) {
            recipeList.add(RecipeIntrospectionUtils.recipeDescriptorFromRecipe(childRecipe));
        }
        return new RecipeDescriptor(recipe.getName(), recipe.getDisplayName(), recipe.getDescription(), recipe.getTags(), Collections.emptyList(), recipe.getLanguages(), recipeList, source);
    }

    public static Constructor<?> getPrimaryConstructor(Class<?> recipeClass) {
        Constructor<?>[] constructors = recipeClass.getConstructors();
        if (constructors.length == 0) {
            throw new RecipeIntrospectionException("Unable to locate primary constructor for Recipe " + recipeClass);
        }
        if (recipeClass.getConstructors().length == 1) {
            return recipeClass.getConstructors()[0];
        }
        for (Constructor<?> constructor : constructors) {
            if (!constructor.isAnnotationPresent(JsonCreator.class)) continue;
            return constructor;
        }
        throw new RecipeIntrospectionException("Unable to locate primary constructor for Recipe " + recipeClass);
    }

    @Nullable
    public static Constructor<?> getZeroArgsConstructor(Class<?> recipeClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = recipeClass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static RecipeDescriptor recipeDescriptorFromRecipe(Recipe recipe) {
        URI recipeSource;
        List<OptionDescriptor> options = RecipeIntrospectionUtils.getOptionsDescriptors(recipe);
        ArrayList<RecipeDescriptor> recipeList = new ArrayList<RecipeDescriptor>();
        for (Recipe next : recipe.getRecipeList()) {
            recipeList.add(RecipeIntrospectionUtils.recipeDescriptorFromRecipe(next));
        }
        try {
            recipeSource = recipe.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return new RecipeDescriptor(recipe.getName(), recipe.getDisplayName(), recipe.getDescription(), recipe.getTags(), options, recipe.getLanguages(), recipeList, recipeSource);
    }

    private static Recipe constructRecipe(Class<?> recipeClass) {
        Constructor<?> primaryConstructor = RecipeIntrospectionUtils.getZeroArgsConstructor(recipeClass);
        if (primaryConstructor == null) {
            primaryConstructor = RecipeIntrospectionUtils.getPrimaryConstructor(recipeClass);
        }
        Object[] constructorArgs = new Object[primaryConstructor.getParameterCount()];
        for (int i = 0; i < primaryConstructor.getParameters().length; ++i) {
            Parameter param = primaryConstructor.getParameters()[i];
            constructorArgs[i] = param.getType().isPrimitive() ? RecipeIntrospectionUtils.getPrimitiveDefault(param.getType()) : null;
        }
        primaryConstructor.setAccessible(true);
        try {
            return (Recipe)primaryConstructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RecipeIntrospectionException("Unable to call primary constructor for Recipe " + recipeClass, e);
        }
    }

    private static List<OptionDescriptor> getOptionDescriptors(Class<?> recipeClass) {
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        for (Field field : recipeClass.getDeclaredFields()) {
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            options.add(new OptionDescriptor(field.getName(), field.getType().getSimpleName(), option.displayName(), option.description(), option.example().isEmpty() ? null : option.example(), (List<String>)(option.valid().length == 1 && option.valid()[0].isEmpty() ? null : Arrays.asList(option.valid())), option.required(), null));
        }
        return options;
    }

    private static List<OptionDescriptor> getOptionsDescriptors(Recipe recipe) {
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        for (Field field : recipe.getClass().getDeclaredFields()) {
            Object fieldValue;
            field.setAccessible(true);
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            try {
                fieldValue = field.get(recipe);
            }
            catch (IllegalAccessException e) {
                throw new RecipeIntrospectionException("Error getting recipe option value, recipe: " + recipe.getClass().getName() + ", option: " + field.getName(), e);
            }
            options.add(new OptionDescriptor(field.getName(), field.getType().getSimpleName(), option.displayName(), option.description(), option.example().isEmpty() ? null : option.example(), (List<String>)(option.valid().length == 1 && option.valid()[0].isEmpty() ? null : Arrays.asList(option.valid())), option.required(), fieldValue));
        }
        return options;
    }

    private static Object getPrimitiveDefault(Class<?> t) {
        if (t.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (t.equals(Short.TYPE)) {
            return (short)0;
        }
        if (t.equals(Integer.TYPE)) {
            return 0;
        }
        if (t.equals(Long.TYPE)) {
            return 0L;
        }
        if (t.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (t.equals(Double.TYPE)) {
            return 0.0;
        }
        if (t.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (t.equals(Boolean.TYPE)) {
            return false;
        }
        throw new RecipeIntrospectionException(t.getCanonicalName() + " is not a supported primitive type");
    }
}

