/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.style.NamedStyles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningLoader
implements ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanningLoader.class);
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
    private final List<RecipeDescriptor> recipeDescriptors = new ArrayList<RecipeDescriptor>();
    private final List<CategoryDescriptor> categoryDescriptors = new ArrayList<CategoryDescriptor>();

    public ClasspathScanningLoader(Properties properties, String[] acceptPackages) {
        this.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties, null);
        this.scanClasses(new ClassGraph(), acceptPackages);
    }

    public ClasspathScanningLoader(Iterable<Path> compileClasspath, Properties properties, String[] acceptPackages) {
        URLClassLoader classpathLoader = new URLClassLoader((URL[])StreamSupport.stream(compileClasspath.spliterator(), false).map(cc -> {
            try {
                return cc.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).toArray(URL[]::new), this.getClass().getClassLoader());
        this.scanYaml(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classpathLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, classpathLoader);
        this.scanClasses(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classpathLoader}), acceptPackages);
    }

    public ClasspathScanningLoader(String jarName, Iterable<Path> compileClasspath, Properties properties, String[] acceptPackages) {
        this(jarName, compileClasspath, properties, null, acceptPackages);
    }

    public ClasspathScanningLoader(String jarName, Iterable<Path> compileClasspath, Properties properties, @Nullable ClassLoader classLoader, String[] acceptPackages) {
        if (classLoader == null) {
            classLoader = new URLClassLoader((URL[])StreamSupport.stream(compileClasspath.spliterator(), false).map(cc -> {
                try {
                    return cc.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
            }).toArray(URL[]::new), this.getClass().getClassLoader());
        }
        this.scanYaml(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, classLoader);
        this.scanClasses(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}), acceptPackages);
    }

    private void scanYaml(ClassGraph classGraph, Properties properties, @Nullable ClassLoader classLoader) {
        try (ScanResult scanResult = classGraph.enableMemoryMapping().scan();){
            ArrayList yamlResourceLoaders = new ArrayList();
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties, classLoader)));
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                this.recipes.addAll(resourceLoader.listRecipes());
                this.categoryDescriptors.addAll(resourceLoader.listCategoryDescriptors());
                this.styles.addAll(resourceLoader.listStyles());
            }
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                this.recipeDescriptors.addAll(resourceLoader.listRecipeDescriptors(this.recipes));
            }
        }
    }

    private void scanClasses(ClassGraph classGraph, String[] acceptPackages) {
        try (ScanResult result = classGraph.ignoreClassVisibility().acceptPackages(acceptPackages).scan();){
            Constructor<?> constructor;
            for (ClassInfo classInfo : result.getSubclasses(Recipe.class.getName())) {
                Class recipeClass = classInfo.loadClass();
                if (recipeClass.equals(DeclarativeRecipe.class) || recipeClass.getEnclosingClass() != null) continue;
                try {
                    this.recipeDescriptors.add(RecipeIntrospectionUtils.recipeDescriptorFromRecipeClass(recipeClass));
                    constructor = RecipeIntrospectionUtils.getZeroArgsConstructor(recipeClass);
                    if (constructor == null) continue;
                    constructor.setAccessible(true);
                    this.recipes.add((Recipe)constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)recipeClass.getName(), (Object)e);
                }
            }
            for (ClassInfo classInfo : result.getSubclasses(NamedStyles.class.getName())) {
                Class styleClass = classInfo.loadClass();
                try {
                    constructor = RecipeIntrospectionUtils.getZeroArgsConstructor(styleClass);
                    if (constructor == null) continue;
                    constructor.setAccessible(true);
                    this.styles.add((NamedStyles)constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)styleClass.getName(), (Object)e);
                }
            }
        }
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.recipeDescriptors;
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.categoryDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.styles;
    }
}

