/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.scheduling.WatchableExecutionContext;

public interface RecipeScheduler {
    default public <T> List<T> mapAsync(List<T> input, UnaryOperator<T> mapFn) {
        CompletableFuture[] futures = new CompletableFuture[input.size()];
        int i = 0;
        for (Object before : input) {
            Callable<Object> updateTreeFn = () -> mapFn.apply(before);
            futures[i++] = this.schedule(updateTreeFn);
        }
        CompletableFuture.allOf(futures).join();
        return ListUtils.map(input, (j, in) -> futures[j].join());
    }

    default public List<Result> scheduleRun(Recipe recipe, List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles, int minCycles) {
        List<? extends SourceFile> acc;
        DistributionSummary.builder((String)"rewrite.recipe.run").tag("recipe", recipe.getDisplayName()).description("The distribution of recipe runs and the size of source file batches given to them to process.").baseUnit("source files").register((MeterRegistry)Metrics.globalRegistry).record((double)before.size());
        HashMap<UUID, Recipe> recipeThatDeletedSourceFile = new HashMap<UUID, Recipe>();
        List<? extends SourceFile> after = acc = before;
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        for (int i = 0; i < maxCycles; ++i) {
            after = this.scheduleVisit(recipe, acc, ctxWithWatch, recipeThatDeletedSourceFile);
            if (i + 1 >= minCycles && (after == acc && !ctxWithWatch.hasNewMessages() || !recipe.causesAnotherCycle())) break;
            acc = after;
            ctxWithWatch.resetHasNewMessages();
        }
        if (after == before) {
            return Collections.emptyList();
        }
        Map sourceFileIdentities = before.stream().collect(Collectors.toMap(Tree::getId, Function.identity()));
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile : after) {
            SourceFile sourceFile2 = (SourceFile)sourceFileIdentities.get(sourceFile.getId());
            if (sourceFile2 == sourceFile) continue;
            if (sourceFile2 == null) {
                results.add(new Result(null, sourceFile, Collections.singleton((Recipe)recipeThatDeletedSourceFile.get(sourceFile.getId()))));
                continue;
            }
            if (sourceFile2.print(Recipe.MARKER_ID_PRINTER, ctx).equals(sourceFile.print(Recipe.MARKER_ID_PRINTER, ctx))) continue;
            results.add(new Result(sourceFile2, sourceFile, sourceFile.getMarkers().findFirst(Recipe.RecipeThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change?")).getRecipes()));
        }
        Set afterIds = after.stream().map(Tree::getId).collect(Collectors.toSet());
        for (SourceFile sourceFile : before) {
            if (afterIds.contains(sourceFile.getId())) continue;
            results.add(new Result(sourceFile, null, Collections.singleton((Recipe)recipeThatDeletedSourceFile.get(sourceFile.getId()))));
        }
        return results;
    }

    default public <S extends SourceFile> List<S> scheduleVisit(Recipe recipe, List<S> before, ExecutionContext ctx, Map<UUID, Recipe> recipeThatDeletedSourceFile) {
        long startTime = System.nanoTime();
        AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean(false);
        if (recipe.getApplicableTest() != null) {
            boolean applicable = false;
            for (SourceFile s2 : before) {
                if (recipe.getApplicableTest().visit(s2, ctx) == s2) continue;
                applicable = true;
                break;
            }
            if (!applicable) {
                return before;
            }
        }
        List<SourceFile> after = !recipe.validate(ctx).isValid() ? before : this.mapAsync(before, s -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.recipe.visit").tag("recipe", recipe.getDisplayName());
            Timer.Sample sample = Timer.start();
            if (recipe.getSingleSourceApplicableTest() != null && recipe.getSingleSourceApplicableTest().visit((Tree)s, ctx) == s) {
                sample.stop(MetricsHelper.successTags(timer, s, "skipped").register((MeterRegistry)Metrics.globalRegistry));
                return s;
            }
            Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
            if (duration.compareTo(ctx.getRunTimeout(before.size())) > 0) {
                if (thrownErrorOnTimeout.compareAndSet(false, true)) {
                    RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                    ctx.getOnError().accept(t);
                    ctx.getOnTimeout().accept(t, ctx);
                }
                sample.stop(MetricsHelper.successTags(timer, s, "timeout").register((MeterRegistry)Metrics.globalRegistry));
                return s;
            }
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                return s;
            }
            try {
                SourceFile afterFile = (SourceFile)recipe.getVisitor().visit((Tree)s, ctx);
                if (afterFile != null && afterFile != s) {
                    afterFile = afterFile.withMarkers(afterFile.getMarkers().computeByType(new Recipe.RecipeThatMadeChanges(recipe), (r1, r2) -> {
                        r1.getRecipes().addAll(r2.getRecipes());
                        return r1;
                    }));
                    sample.stop(MetricsHelper.successTags(timer, s, "changed").register((MeterRegistry)Metrics.globalRegistry));
                } else if (afterFile == null) {
                    recipeThatDeletedSourceFile.put(s.getId(), recipe);
                    sample.stop(MetricsHelper.successTags(timer, s, "deleted").register((MeterRegistry)Metrics.globalRegistry));
                } else {
                    sample.stop(MetricsHelper.successTags(timer, s, "unchanged").register((MeterRegistry)Metrics.globalRegistry));
                }
                return afterFile;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags(timer, s, t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(t);
                return s;
            }
        });
        List<SourceFile> afterWidened = recipe.visit(after, ctx);
        for (SourceFile maybeGenerated : afterWidened) {
            if (after.contains(maybeGenerated)) continue;
            recipeThatDeletedSourceFile.put(maybeGenerated.getId(), recipe);
        }
        for (SourceFile maybeDeleted : after) {
            if (afterWidened.contains(maybeDeleted)) continue;
            recipeThatDeletedSourceFile.put(maybeDeleted.getId(), recipe);
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                return afterWidened;
            }
            afterWidened = this.scheduleVisit(r, afterWidened, ctx, recipeThatDeletedSourceFile);
        }
        return afterWidened;
    }

    public <T> CompletableFuture<T> schedule(Callable<T> var1);
}

