/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.openrewrite.internal.lang.Nullable;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> insertInOrder(List<T> ls, T insert, Comparator<T> naturalOrdering) {
        if (ls == null || ls.isEmpty()) {
            return Collections.singletonList(insert);
        }
        ArrayList<T> ordered = new ArrayList<T>(ls);
        ordered.add(insert);
        ordered.sort(naturalOrdering);
        Object comesAfter = null;
        for (Object t : ordered) {
            if (t == insert) break;
            comesAfter = t;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        if (comesAfter == null) {
            newLs.add(0, insert);
        } else {
            for (int i = 0; i < newLs.size(); ++i) {
                if (newLs.get(i) != comesAfter) continue;
                newLs.add(i + 1, insert);
            }
        }
        return newLs;
    }

    public static <T> List<T> mapLast(List<T> ls, UnaryOperator<T> mapLast) {
        Object newLast;
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        T last = ls.get(ls.size() - 1);
        if (last != (newLast = mapLast.apply(last))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newLast == null) {
                newLs.remove(ls.size() - 1);
            } else {
                newLs.set(ls.size() - 1, newLast);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> List<T> mapFirst(List<T> ls, UnaryOperator<T> mapFirst) {
        Object newFirst;
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        T first = ls.iterator().next();
        if (first != (newFirst = mapFirst.apply(first))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newFirst == null) {
                newLs.remove(0);
            } else {
                newLs.set(0, newFirst);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> List<T> map(List<T> ls, BiFunction<Integer, T, T> map) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<T> newLs = ls;
        for (int i = 0; i < ls.size(); ++i) {
            T tree = ls.get(i);
            T newTree = map.apply(i, (Integer)tree);
            if (newTree == tree) continue;
            if (newLs == ls) {
                newLs = new ArrayList<T>(ls);
            }
            newLs.set(i, newTree);
        }
        if (newLs != ls) {
            while (newLs.remove(null)) {
            }
        }
        return newLs;
    }

    public static <T> List<T> map(List<T> ls, UnaryOperator<T> map) {
        return ListUtils.map(ls, (Integer i, T t) -> map.apply(t));
    }

    public static <T> List<T> map(List<T> ls, ForkJoinPool pool, UnaryOperator<T> map) {
        return ListUtils.map(ls, pool, (Integer i, T t) -> map.apply(t));
    }

    public static <T> List<T> map(List<T> ls, @Nullable ForkJoinPool pool, BiFunction<Integer, T, T> map) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        AtomicReference newLs = new AtomicReference(ls);
        for (int i = 0; i < ls.size(); ++i) {
            int index = i;
            Runnable updateTreeFn = () -> {
                Object tree = ls.get(index);
                Object newTree = map.apply(index, tree);
                if (newTree != tree) {
                    ((List)newLs.updateAndGet(l -> l == ls ? new ArrayList(ls) : l)).set(index, newTree);
                }
            };
            if (pool == null) {
                updateTreeFn.run();
                continue;
            }
            ForkJoinTask<?> task = ForkJoinTask.adapt(updateTreeFn);
            pool.invoke(task);
            task.join();
        }
        if (newLs.get() != ls) {
            while (newLs.get().remove(null)) {
            }
        }
        return newLs.get();
    }

    public static <T> List<T> concat(@Nullable List<T> ls, T t) {
        ArrayList<T> newLs = ls == null ? new ArrayList<T>(1) : new ArrayList<T>(ls);
        newLs.add(t);
        return newLs;
    }

    public static <T> List<T> concat(T t, @Nullable List<T> ls) {
        ArrayList<T> newLs = ls == null ? new ArrayList<T>(1) : new ArrayList(ls.size() + 1);
        newLs.add(t);
        if (ls != null) {
            newLs.addAll(ls);
        }
        return newLs;
    }

    public static <T> List<T> concatAll(@Nullable List<T> ls, List<T> t) {
        if (ls == null) {
            return t;
        }
        if (t.isEmpty()) {
            return ls;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        newLs.addAll(t);
        return newLs;
    }

    public static <T> List<T> insertAll(List<T> ls, int index, List<T> t) {
        if (ls == null) {
            return t;
        }
        if (t.isEmpty()) {
            return ls;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        newLs.addAll(index, t);
        return newLs;
    }
}

