/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public final class Markers {
    public static final Markers EMPTY = new Markers(Tree.randomId(), Collections.emptyList());
    private final UUID id;
    private final List<Marker> markers;

    public static Markers build(Collection<? extends Marker> markers) {
        ArrayList<Marker> markerList;
        if (markers instanceof List) {
            markerList = (ArrayList<Marker>)markers;
        } else {
            markerList = new ArrayList<Marker>(markers.size());
            markerList.addAll(markers);
        }
        return markers.isEmpty() ? EMPTY : new Markers(Tree.randomId(), markerList);
    }

    public Collection<? extends Marker> entries() {
        return this.markers;
    }

    public Markers add(Marker marker) {
        for (Marker m : this.markers) {
            if (!marker.equals(m)) continue;
            return this;
        }
        ArrayList<Marker> updatedmarker = new ArrayList<Marker>(this.markers);
        updatedmarker.add(marker);
        return new Markers(this.id, updatedmarker);
    }

    public <M extends Marker> Markers computeByType(M identity, BinaryOperator<M> remappingFunction) {
        AtomicBoolean updated = new AtomicBoolean(false);
        List<Marker> markers = ListUtils.map(this.markers, m -> {
            if (m.getClass().equals(identity.getClass())) {
                updated.set(true);
                return (Marker)remappingFunction.apply(m, identity);
            }
            return m;
        });
        return this.withMarkers(!updated.get() ? ListUtils.concat(markers, identity) : markers);
    }

    public Markers removeByType(Class<? extends Marker> type) {
        return this.withMarkers(ListUtils.map(this.markers, m -> type.equals(m.getClass()) ? null : m));
    }

    public <M extends Marker> Markers setByType(M m) {
        return this.computeByType(m, (existing, replacement) -> replacement);
    }

    public <M extends Marker> Markers compute(M identity, BinaryOperator<M> remappingFunction) {
        AtomicBoolean foundEqualMarker = new AtomicBoolean(false);
        List<Marker> updatedMarkers = ListUtils.map(this.markers, m -> {
            if (m.equals(identity)) {
                foundEqualMarker.set(true);
                return (Marker)remappingFunction.apply(m, identity);
            }
            return m;
        });
        if (!foundEqualMarker.get()) {
            updatedMarkers = ListUtils.concat(updatedMarkers, identity);
        }
        return this.withMarkers(updatedMarkers);
    }

    public <M extends Marker> Markers addIfAbsent(M m) {
        return this.compute(m, (m1, m2) -> m1);
    }

    public <M extends Marker> List<M> findAll(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).collect(Collectors.toList());
    }

    public <M extends Marker> Optional<M> findFirst(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).findFirst();
    }

    @Deprecated
    public Markers searchResult() {
        return this.searchResult(null);
    }

    @Deprecated
    public Markers searchResult(@Nullable String description) {
        return this.computeByType(new SearchResult(Tree.randomId(), description), (s1, s2) -> s1 == null ? s2 : s1);
    }

    public Markers(UUID id, List<Marker> markers) {
        this.id = id;
        this.markers = markers;
    }

    public UUID getId() {
        return this.id;
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Markers)) {
            return false;
        }
        Markers other = (Markers)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<Marker> this$markers = this.getMarkers();
        List<Marker> other$markers = other.getMarkers();
        return !(this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<Marker> $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "Markers(id=" + this.getId() + ", markers=" + this.getMarkers() + ")";
    }

    @NonNull
    public Markers withId(UUID id) {
        return this.id == id ? this : new Markers(id, this.markers);
    }

    @NonNull
    public Markers withMarkers(List<Marker> markers) {
        return this.markers == markers ? this : new Markers(this.id, markers);
    }
}

